<?php

namespace Sura\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Opcionales StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Opcionales
 * @subpackage Structs
 */
class Opcionales extends AbstractStructBase
{
    /**
     * The asistencias
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $asistencias;
    /**
     * The autoReemplazo
     * @var string
     */
    public $autoReemplazo;
    /**
     * The rCExceso
     * @var string
     */
    public $rCExceso;
    /**
     * The taller
     * @var string
     */
    public $taller;
    /**
     * Constructor method for Opcionales
     * @uses Opcionales::setAsistencias()
     * @uses Opcionales::setAutoReemplazo()
     * @uses Opcionales::setRCExceso()
     * @uses Opcionales::setTaller()
     * @param string $asistencias
     * @param string $autoReemplazo
     * @param string $rCExceso
     * @param string $taller
     */
    public function __construct($asistencias = null, $autoReemplazo = null, $rCExceso = null, $taller = null)
    {
        $this
            ->setAsistencias($asistencias)
            ->setAutoReemplazo($autoReemplazo)
            ->setRCExceso($rCExceso)
            ->setTaller($taller);
    }
    /**
     * Get asistencias value
     * @return string|null
     */
    public function getAsistencias()
    {
        return $this->asistencias;
    }
    /**
     * Set asistencias value
     * @uses \Sura\Autoclick\EnumType\OpcionalAsistencias::valueIsValid()
     * @uses \Sura\Autoclick\EnumType\OpcionalAsistencias::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $asistencias
     * @return \Sura\Autoclick\StructType\Opcionales
     */
    public function setAsistencias($asistencias = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Autoclick\EnumType\OpcionalAsistencias::valueIsValid($asistencias)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $asistencias, implode(', ', \Sura\Autoclick\EnumType\OpcionalAsistencias::getValidValues())), __LINE__);
        }
        $this->asistencias = $asistencias;
        return $this;
    }
    /**
     * Get autoReemplazo value
     * @return string|null
     */
    public function getAutoReemplazo()
    {
        return $this->autoReemplazo;
    }
    /**
     * Set autoReemplazo value
     * @uses \Sura\Autoclick\EnumType\OpcionalAutoReemplazo::valueIsValid()
     * @uses \Sura\Autoclick\EnumType\OpcionalAutoReemplazo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoReemplazo
     * @return \Sura\Autoclick\StructType\Opcionales
     */
    public function setAutoReemplazo($autoReemplazo = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Autoclick\EnumType\OpcionalAutoReemplazo::valueIsValid($autoReemplazo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $autoReemplazo, implode(', ', \Sura\Autoclick\EnumType\OpcionalAutoReemplazo::getValidValues())), __LINE__);
        }
        $this->autoReemplazo = $autoReemplazo;
        return $this;
    }
    /**
     * Get rCExceso value
     * @return string|null
     */
    public function getRCExceso()
    {
        return $this->rCExceso;
    }
    /**
     * Set rCExceso value
     * @uses \Sura\Autoclick\EnumType\OpcionalRCExceso::valueIsValid()
     * @uses \Sura\Autoclick\EnumType\OpcionalRCExceso::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rCExceso
     * @return \Sura\Autoclick\StructType\Opcionales
     */
    public function setRCExceso($rCExceso = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Autoclick\EnumType\OpcionalRCExceso::valueIsValid($rCExceso)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rCExceso, implode(', ', \Sura\Autoclick\EnumType\OpcionalRCExceso::getValidValues())), __LINE__);
        }
        $this->rCExceso = $rCExceso;
        return $this;
    }
    /**
     * Get taller value
     * @return string|null
     */
    public function getTaller()
    {
        return $this->taller;
    }
    /**
     * Set taller value
     * @uses \Sura\Autoclick\EnumType\OpcionalTaller::valueIsValid()
     * @uses \Sura\Autoclick\EnumType\OpcionalTaller::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taller
     * @return \Sura\Autoclick\StructType\Opcionales
     */
    public function setTaller($taller = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Autoclick\EnumType\OpcionalTaller::valueIsValid($taller)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $taller, implode(', ', \Sura\Autoclick\EnumType\OpcionalTaller::getValidValues())), __LINE__);
        }
        $this->taller = $taller;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Autoclick\StructType\Opcionales
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
