<?php

namespace Sura\Autoclick\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cotiza ServiceType
 * @subpackage Services
 */
class Cotiza extends AbstractSoapClientBase
{
    /**
     * Sets the DatosTransaccion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sura\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDatosTransaccion(\Sura\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion, $nameSpace = 'http://ws.rsa.cl/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DatosTransaccion', $datosTransaccion, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CotizaOfertaKilometros
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Autoclick\StructType\CotizacionOfertaKilometroResponse|bool
     */
    public function CotizaOfertaKilometros(\Sura\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CotizaOfertaKilometros($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaOferta
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Autoclick\StructType\CotizacionOfertaResponse|bool
     */
    public function CotizaOferta(\Sura\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CotizaOferta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaProducto
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Autoclick\StructType\CotizaProductoRequest $parameters
     * @return \Sura\Autoclick\StructType\CotizacionProductoResponse|bool
     */
    public function CotizaProducto(\Sura\Autoclick\StructType\CotizaProductoRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CotizaProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaProductoBase
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Autoclick\StructType\CotizaProductoRequest $parameters
     * @return \Sura\Autoclick\StructType\CotizacionProductoBaseResponse|bool
     */
    public function CotizaProductoBase(\Sura\Autoclick\StructType\CotizaProductoRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CotizaProductoBase($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaOfertaBase
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Autoclick\StructType\CotizacionOfertaBaseResponse|bool
     */
    public function CotizaOfertaBase(\Sura\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CotizaOfertaBase($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaOfertaBaseFalabella
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Autoclick\StructType\CotizacionOfertaBaseResponse|bool
     */
    public function CotizaOfertaBaseFalabella(\Sura\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CotizaOfertaBaseFalabella($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sura\Autoclick\StructType\CotizacionOfertaBaseResponse|\Sura\Autoclick\StructType\CotizacionOfertaKilometroResponse|\Sura\Autoclick\StructType\CotizacionOfertaResponse|\Sura\Autoclick\StructType\CotizacionProductoBaseResponse|\Sura\Autoclick\StructType\CotizacionProductoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
