<?php

namespace Sura\Services\Autoclick\EnumType;

/**
 * This class stands for SexoEnum EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SexoEnum
 * @subpackage Enumerations
 */
class SexoEnum
{
    /**
     * Constant for value 'Masculino'
     * @return string 'Masculino'
     */
    const VALUE_MASCULINO = 'Masculino';
    /**
     * Constant for value 'Femenino'
     * @return string 'Femenino'
     */
    const VALUE_FEMENINO = 'Femenino';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MASCULINO
     * @uses self::VALUE_FEMENINO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MASCULINO,
            self::VALUE_FEMENINO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
