<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmitirPolizaModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EmitirPolizaModel
 * @subpackage Structs
 */
class EmitirPolizaModel extends AbstractStructBase
{
    /**
     * The InfoPoliza
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Sura\Services\Autoclick\StructType\PolizaExternaModel
     */
    public $InfoPoliza;
    /**
     * The cotizacionServicioID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $cotizacionServicioID;
    /**
     * Constructor method for EmitirPolizaModel
     * @uses EmitirPolizaModel::setInfoPoliza()
     * @uses EmitirPolizaModel::setCotizacionServicioID()
     * @param \Sura\Services\Autoclick\StructType\PolizaExternaModel $infoPoliza
     * @param string $cotizacionServicioID
     */
    public function __construct(\Sura\Services\Autoclick\StructType\PolizaExternaModel $infoPoliza = null, $cotizacionServicioID = null)
    {
        $this
            ->setInfoPoliza($infoPoliza)
            ->setCotizacionServicioID($cotizacionServicioID);
    }
    /**
     * Get InfoPoliza value
     * @return \Sura\Services\Autoclick\StructType\PolizaExternaModel|null
     */
    public function getInfoPoliza()
    {
        return $this->InfoPoliza;
    }
    /**
     * Set InfoPoliza value
     * @param \Sura\Services\Autoclick\StructType\PolizaExternaModel $infoPoliza
     * @return \Sura\Services\Autoclick\StructType\EmitirPolizaModel
     */
    public function setInfoPoliza(\Sura\Services\Autoclick\StructType\PolizaExternaModel $infoPoliza = null)
    {
        $this->InfoPoliza = $infoPoliza;
        return $this;
    }
    /**
     * Get cotizacionServicioID value
     * @return string|null
     */
    public function getCotizacionServicioID()
    {
        return $this->cotizacionServicioID;
    }
    /**
     * Set cotizacionServicioID value
     * @param string $cotizacionServicioID
     * @return \Sura\Services\Autoclick\StructType\EmitirPolizaModel
     */
    public function setCotizacionServicioID($cotizacionServicioID = null)
    {
        // validation for constraint: string
        if (!is_null($cotizacionServicioID) && !is_string($cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cotizacionServicioID, true), gettype($cotizacionServicioID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cotizacionServicioID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cotizacionServicioID, true)), __LINE__);
        }
        $this->cotizacionServicioID = $cotizacionServicioID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Services\Autoclick\StructType\EmitirPolizaModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
