<?php

namespace Sura\Services\Autoclick\EnumType;

/**
 * This class stands for OpcionalAsistencias EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OpcionalAsistencias
 * @subpackage Enumerations
 */
class OpcionalAsistencias
{
    /**
     * Constant for value 'Full'
     * @return string 'Full'
     */
    const VALUE_FULL = 'Full';
    /**
     * Constant for value 'Basic'
     * @return string 'Basic'
     */
    const VALUE_BASIC = 'Basic';
    /**
     * Constant for value 'SinOpcional'
     * @return string 'SinOpcional'
     */
    const VALUE_SIN_OPCIONAL = 'SinOpcional';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FULL
     * @uses self::VALUE_BASIC
     * @uses self::VALUE_SIN_OPCIONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FULL,
            self::VALUE_BASIC,
            self::VALUE_SIN_OPCIONAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
