<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcesarOfertaModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProcesarOfertaModel
 * @subpackage Structs
 */
class ProcesarOfertaModel extends AbstractStructBase
{
    /**
     * The cotizacionServicioID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $cotizacionServicioID;
    /**
     * The nombrePlan
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nombrePlan;
    /**
     * Constructor method for ProcesarOfertaModel
     * @uses ProcesarOfertaModel::setCotizacionServicioID()
     * @uses ProcesarOfertaModel::setNombrePlan()
     * @param string $cotizacionServicioID
     * @param string $nombrePlan
     */
    public function __construct($cotizacionServicioID = null, $nombrePlan = null)
    {
        $this
            ->setCotizacionServicioID($cotizacionServicioID)
            ->setNombrePlan($nombrePlan);
    }
    /**
     * Get cotizacionServicioID value
     * @return string|null
     */
    public function getCotizacionServicioID()
    {
        return $this->cotizacionServicioID;
    }
    /**
     * Set cotizacionServicioID value
     * @param string $cotizacionServicioID
     * @return \Sura\Services\Autoclick\StructType\ProcesarOfertaModel
     */
    public function setCotizacionServicioID($cotizacionServicioID = null)
    {
        // validation for constraint: string
        if (!is_null($cotizacionServicioID) && !is_string($cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cotizacionServicioID, true), gettype($cotizacionServicioID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cotizacionServicioID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cotizacionServicioID, true)), __LINE__);
        }
        $this->cotizacionServicioID = $cotizacionServicioID;
        return $this;
    }
    /**
     * Get nombrePlan value
     * @return string|null
     */
    public function getNombrePlan()
    {
        return $this->nombrePlan;
    }
    /**
     * Set nombrePlan value
     * @param string $nombrePlan
     * @return \Sura\Services\Autoclick\StructType\ProcesarOfertaModel
     */
    public function setNombrePlan($nombrePlan = null)
    {
        // validation for constraint: string
        if (!is_null($nombrePlan) && !is_string($nombrePlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombrePlan, true), gettype($nombrePlan)), __LINE__);
        }
        $this->nombrePlan = $nombrePlan;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Services\Autoclick\StructType\ProcesarOfertaModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
