<?php

namespace Sura\Services\Autoclick\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cotiza ServiceType
 * @subpackage Services
 */
class Cotiza extends AbstractSoapClientBase
{
    /**
     * Sets the DatosTransaccion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sura\Services\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDatosTransaccion(\Sura\Services\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion, $nameSpace = 'http://ws.rsa.cl/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DatosTransaccion', $datosTransaccion, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CotizaOfertaKilometros
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\CotizacionOfertaKilometroResponse|bool
     */
    public function CotizaOfertaKilometros(\Sura\Services\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaOfertaKilometros($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaOferta
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\CotizacionOfertaResponse|bool
     */
    public function CotizaOferta(\Sura\Services\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaOferta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaProducto
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\CotizaProductoRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\CotizacionProductoResponse|bool
     */
    public function CotizaProducto(\Sura\Services\Autoclick\StructType\CotizaProductoRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaProductoBase
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\CotizaProductoRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\CotizacionProductoBaseResponse|bool
     */
    public function CotizaProductoBase(\Sura\Services\Autoclick\StructType\CotizaProductoRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaProductoBase($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaOfertaBase
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\CotizacionOfertaBaseResponse|bool
     */
    public function CotizaOfertaBase(\Sura\Services\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaOfertaBase($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaOfertaBaseFalabella
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\CotizacionOfertaBaseResponse|bool
     */
    public function CotizaOfertaBaseFalabella(\Sura\Services\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaOfertaBaseFalabella($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sura\Services\Autoclick\StructType\CotizacionOfertaBaseResponse|\Sura\Services\Autoclick\StructType\CotizacionOfertaKilometroResponse|\Sura\Services\Autoclick\StructType\CotizacionOfertaResponse|\Sura\Services\Autoclick\StructType\CotizacionProductoBaseResponse|\Sura\Services\Autoclick\StructType\CotizacionProductoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
