<?php

namespace Sura\Services\Autoclick\EnumType;

/**
 * This class stands for TipoAuto EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TipoAuto
 * @subpackage Enumerations
 */
class TipoAuto
{
    /**
     * Constant for value 'SeleccioneTipo'
     * @return string 'SeleccioneTipo'
     */
    const VALUE_SELECCIONE_TIPO = 'SeleccioneTipo';
    /**
     * Constant for value 'AUTOMOVIL'
     * @return string 'AUTOMOVIL'
     */
    const VALUE_AUTOMOVIL = 'AUTOMOVIL';
    /**
     * Constant for value 'CAMIONETA'
     * @return string 'CAMIONETA'
     */
    const VALUE_CAMIONETA = 'CAMIONETA';
    /**
     * Constant for value 'CAMION'
     * @return string 'CAMION'
     */
    const VALUE_CAMION = 'CAMION';
    /**
     * Constant for value 'FURGON'
     * @return string 'FURGON'
     */
    const VALUE_FURGON = 'FURGON';
    /**
     * Constant for value 'MOTO_MOTONETA'
     * @return string 'MOTO_MOTONETA'
     */
    const VALUE_MOTO_MOTONETA = 'MOTO_MOTONETA';
    /**
     * Constant for value 'BUS'
     * @return string 'BUS'
     */
    const VALUE_BUS = 'BUS';
    /**
     * Constant for value 'ACOPLADO_TRAILER'
     * @return string 'ACOPLADO_TRAILER'
     */
    const VALUE_ACOPLADO_TRAILER = 'ACOPLADO_TRAILER';
    /**
     * Constant for value 'STATIONWAGON'
     * @return string 'STATIONWAGON'
     */
    const VALUE_STATIONWAGON = 'STATIONWAGON';
    /**
     * Constant for value 'JEEP'
     * @return string 'JEEP'
     */
    const VALUE_JEEP = 'JEEP';
    /**
     * Constant for value 'MOTORHOME_CASARODANTE'
     * @return string 'MOTORHOME_CASARODANTE'
     */
    const VALUE_MOTORHOME_CASARODANTE = 'MOTORHOME_CASARODANTE';
    /**
     * Constant for value 'MINIBUS'
     * @return string 'MINIBUS'
     */
    const VALUE_MINIBUS = 'MINIBUS';
    /**
     * Constant for value 'VEHICULODEEMERGENCIA'
     * @return string 'VEHICULODEEMERGENCIA'
     */
    const VALUE_VEHICULODEEMERGENCIA = 'VEHICULODEEMERGENCIA';
    /**
     * Constant for value 'OTROS'
     * @return string 'OTROS'
     */
    const VALUE_OTROS = 'OTROS';
    /**
     * Constant for value 'SUV'
     * @return string 'SUV'
     */
    const VALUE_SUV = 'SUV';
    /**
     * Constant for value 'VAN'
     * @return string 'VAN'
     */
    const VALUE_VAN = 'VAN';
    /**
     * Constant for value 'MIGRACION'
     * @return string 'MIGRACION'
     */
    const VALUE_MIGRACION = 'MIGRACION';
    /**
     * Constant for value 'CARROSDEARRASTRE'
     * @return string 'CARROSDEARRASTRE'
     */
    const VALUE_CARROSDEARRASTRE = 'CARROSDEARRASTRE';
    /**
     * Constant for value 'SEGUNDETALLE'
     * @return string 'SEGUNDETALLE'
     */
    const VALUE_SEGUNDETALLE = 'SEGUNDETALLE';
    /**
     * Constant for value 'REMOLQUE'
     * @return string 'REMOLQUE'
     */
    const VALUE_REMOLQUE = 'REMOLQUE';
    /**
     * Constant for value 'SEMIREMOLQUE'
     * @return string 'SEMIREMOLQUE'
     */
    const VALUE_SEMIREMOLQUE = 'SEMIREMOLQUE';
    /**
     * Constant for value 'TRACTOCAMION'
     * @return string 'TRACTOCAMION'
     */
    const VALUE_TRACTOCAMION = 'TRACTOCAMION';
    /**
     * Constant for value 'MINI_BUS'
     * @return string 'MINI_BUS'
     */
    const VALUE_MINI_BUS = 'MINI_BUS';
    /**
     * Constant for value 'RAMPLA'
     * @return string 'RAMPLA'
     */
    const VALUE_RAMPLA = 'RAMPLA';
    /**
     * Constant for value 'TAXITURISMO'
     * @return string 'TAXITURISMO'
     */
    const VALUE_TAXITURISMO = 'TAXITURISMO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SELECCIONE_TIPO
     * @uses self::VALUE_AUTOMOVIL
     * @uses self::VALUE_CAMIONETA
     * @uses self::VALUE_CAMION
     * @uses self::VALUE_FURGON
     * @uses self::VALUE_MOTO_MOTONETA
     * @uses self::VALUE_BUS
     * @uses self::VALUE_ACOPLADO_TRAILER
     * @uses self::VALUE_STATIONWAGON
     * @uses self::VALUE_JEEP
     * @uses self::VALUE_MOTORHOME_CASARODANTE
     * @uses self::VALUE_MINIBUS
     * @uses self::VALUE_VEHICULODEEMERGENCIA
     * @uses self::VALUE_OTROS
     * @uses self::VALUE_SUV
     * @uses self::VALUE_VAN
     * @uses self::VALUE_MIGRACION
     * @uses self::VALUE_CARROSDEARRASTRE
     * @uses self::VALUE_SEGUNDETALLE
     * @uses self::VALUE_REMOLQUE
     * @uses self::VALUE_SEMIREMOLQUE
     * @uses self::VALUE_TRACTOCAMION
     * @uses self::VALUE_MINI_BUS
     * @uses self::VALUE_RAMPLA
     * @uses self::VALUE_TAXITURISMO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SELECCIONE_TIPO,
            self::VALUE_AUTOMOVIL,
            self::VALUE_CAMIONETA,
            self::VALUE_CAMION,
            self::VALUE_FURGON,
            self::VALUE_MOTO_MOTONETA,
            self::VALUE_BUS,
            self::VALUE_ACOPLADO_TRAILER,
            self::VALUE_STATIONWAGON,
            self::VALUE_JEEP,
            self::VALUE_MOTORHOME_CASARODANTE,
            self::VALUE_MINIBUS,
            self::VALUE_VEHICULODEEMERGENCIA,
            self::VALUE_OTROS,
            self::VALUE_SUV,
            self::VALUE_VAN,
            self::VALUE_MIGRACION,
            self::VALUE_CARROSDEARRASTRE,
            self::VALUE_SEGUNDETALLE,
            self::VALUE_REMOLQUE,
            self::VALUE_SEMIREMOLQUE,
            self::VALUE_TRACTOCAMION,
            self::VALUE_MINI_BUS,
            self::VALUE_RAMPLA,
            self::VALUE_TAXITURISMO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
