<?php

namespace Sura\Services\Autoclick\EnumType;

/**
 * This class stands for DiaPagos EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DiaPagos
 * @subpackage Enumerations
 */
class DiaPagos
{
    /**
     * Constant for value 'Cinco'
     * @return string 'Cinco'
     */
    const VALUE_CINCO = 'Cinco';
    /**
     * Constant for value 'Quince'
     * @return string 'Quince'
     */
    const VALUE_QUINCE = 'Quince';
    /**
     * Constant for value 'VeintiCinco'
     * @return string 'VeintiCinco'
     */
    const VALUE_VEINTI_CINCO = 'VeintiCinco';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CINCO
     * @uses self::VALUE_QUINCE
     * @uses self::VALUE_VEINTI_CINCO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CINCO,
            self::VALUE_QUINCE,
            self::VALUE_VEINTI_CINCO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
