<?php

namespace Sura\Services\Autoclick\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeducible ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDeducible
 * @subpackage Arrays
 */
class ArrayOfDeducible extends AbstractStructArrayBase
{
    /**
     * The Deducible
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Services\Autoclick\StructType\Deducible[]
     */
    public $Deducible;
    /**
     * Constructor method for ArrayOfDeducible
     * @uses ArrayOfDeducible::setDeducible()
     * @param \Sura\Services\Autoclick\StructType\Deducible[] $deducible
     */
    public function __construct(array $deducible = array())
    {
        $this
            ->setDeducible($deducible);
    }
    /**
     * Get Deducible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Services\Autoclick\StructType\Deducible[]|null
     */
    public function getDeducible()
    {
        return isset($this->Deducible) ? $this->Deducible : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeducible method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeducible method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeducibleForArrayConstraintsFromSetDeducible(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDeducibleDeducibleItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeducibleDeducibleItem instanceof \Sura\Services\Autoclick\StructType\Deducible) {
                $invalidValues[] = is_object($arrayOfDeducibleDeducibleItem) ? get_class($arrayOfDeducibleDeducibleItem) : sprintf('%s(%s)', gettype($arrayOfDeducibleDeducibleItem), var_export($arrayOfDeducibleDeducibleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Deducible property can only contain items of type \Sura\Services\Autoclick\StructType\Deducible, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Deducible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Sura\Services\Autoclick\StructType\Deducible[] $deducible
     * @return \Sura\Services\Autoclick\ArrayType\ArrayOfDeducible
     */
    public function setDeducible(array $deducible = array())
    {
        // validation for constraint: array
        if ('' !== ($deducibleArrayErrorMessage = self::validateDeducibleForArrayConstraintsFromSetDeducible($deducible))) {
            throw new \InvalidArgumentException($deducibleArrayErrorMessage, __LINE__);
        }
        if (is_null($deducible) || (is_array($deducible) && empty($deducible))) {
            unset($this->Deducible);
        } else {
            $this->Deducible = $deducible;
        }
        return $this;
    }
    /**
     * Add item to Deducible value
     * @throws \InvalidArgumentException
     * @param \Sura\Services\Autoclick\StructType\Deducible $item
     * @return \Sura\Services\Autoclick\ArrayType\ArrayOfDeducible
     */
    public function addToDeducible(\Sura\Services\Autoclick\StructType\Deducible $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sura\Services\Autoclick\StructType\Deducible) {
            throw new \InvalidArgumentException(sprintf('The Deducible property can only contain items of type \Sura\Services\Autoclick\StructType\Deducible, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Deducible[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Sura\Services\Autoclick\StructType\Deducible|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Sura\Services\Autoclick\StructType\Deducible|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Sura\Services\Autoclick\StructType\Deducible|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Sura\Services\Autoclick\StructType\Deducible|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Sura\Services\Autoclick\StructType\Deducible|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Deducible
     */
    public function getAttributeName()
    {
        return 'Deducible';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Services\Autoclick\ArrayType\ArrayOfDeducible
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
