<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Deducible StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Deducible
 * @subpackage Structs
 */
class Deducible extends AbstractStructBase
{
    /**
     * The Coberturas
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Sura\Services\Autoclick\ArrayType\ArrayOfDeducibleCobertura
     */
    public $Coberturas;
    /**
     * The Cuotas
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Sura\Services\Autoclick\ArrayType\ArrayOfCuota
     */
    public $Cuotas;
    /**
     * The Opcionales
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Sura\Services\Autoclick\ArrayType\ArrayOfOpcional
     */
    public $Opcionales;
    /**
     * The codigoDeducible
     * @var int
     */
    public $codigoDeducible;
    /**
     * The deducible
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deducible;
    /**
     * The esPrimaMinima
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $esPrimaMinima;
    /**
     * The nombrePlan
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nombrePlan;
    /**
     * The plan
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $plan;
    /**
     * The valorEnPeso
     * @var int
     */
    public $valorEnPeso;
    /**
     * The valorEnUf
     * @var float
     */
    public $valorEnUf;
    /**
     * The valorUf
     * @var float
     */
    public $valorUf;
    /**
     * Constructor method for Deducible
     * @uses Deducible::setCoberturas()
     * @uses Deducible::setCuotas()
     * @uses Deducible::setOpcionales()
     * @uses Deducible::setCodigoDeducible()
     * @uses Deducible::setDeducible()
     * @uses Deducible::setEsPrimaMinima()
     * @uses Deducible::setNombrePlan()
     * @uses Deducible::setPlan()
     * @uses Deducible::setValorEnPeso()
     * @uses Deducible::setValorEnUf()
     * @uses Deducible::setValorUf()
     * @param \Sura\Services\Autoclick\ArrayType\ArrayOfDeducibleCobertura $coberturas
     * @param \Sura\Services\Autoclick\ArrayType\ArrayOfCuota $cuotas
     * @param \Sura\Services\Autoclick\ArrayType\ArrayOfOpcional $opcionales
     * @param int $codigoDeducible
     * @param string $deducible
     * @param bool $esPrimaMinima
     * @param string $nombrePlan
     * @param string $plan
     * @param int $valorEnPeso
     * @param float $valorEnUf
     * @param float $valorUf
     */
    public function __construct(\Sura\Services\Autoclick\ArrayType\ArrayOfDeducibleCobertura $coberturas = null, \Sura\Services\Autoclick\ArrayType\ArrayOfCuota $cuotas = null, \Sura\Services\Autoclick\ArrayType\ArrayOfOpcional $opcionales = null, $codigoDeducible = null, $deducible = null, $esPrimaMinima = null, $nombrePlan = null, $plan = null, $valorEnPeso = null, $valorEnUf = null, $valorUf = null)
    {
        $this
            ->setCoberturas($coberturas)
            ->setCuotas($cuotas)
            ->setOpcionales($opcionales)
            ->setCodigoDeducible($codigoDeducible)
            ->setDeducible($deducible)
            ->setEsPrimaMinima($esPrimaMinima)
            ->setNombrePlan($nombrePlan)
            ->setPlan($plan)
            ->setValorEnPeso($valorEnPeso)
            ->setValorEnUf($valorEnUf)
            ->setValorUf($valorUf);
    }
    /**
     * Get Coberturas value
     * @return \Sura\Services\Autoclick\ArrayType\ArrayOfDeducibleCobertura|null
     */
    public function getCoberturas()
    {
        return $this->Coberturas;
    }
    /**
     * Set Coberturas value
     * @param \Sura\Services\Autoclick\ArrayType\ArrayOfDeducibleCobertura $coberturas
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setCoberturas(\Sura\Services\Autoclick\ArrayType\ArrayOfDeducibleCobertura $coberturas = null)
    {
        $this->Coberturas = $coberturas;
        return $this;
    }
    /**
     * Get Cuotas value
     * @return \Sura\Services\Autoclick\ArrayType\ArrayOfCuota|null
     */
    public function getCuotas()
    {
        return $this->Cuotas;
    }
    /**
     * Set Cuotas value
     * @param \Sura\Services\Autoclick\ArrayType\ArrayOfCuota $cuotas
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setCuotas(\Sura\Services\Autoclick\ArrayType\ArrayOfCuota $cuotas = null)
    {
        $this->Cuotas = $cuotas;
        return $this;
    }
    /**
     * Get Opcionales value
     * @return \Sura\Services\Autoclick\ArrayType\ArrayOfOpcional|null
     */
    public function getOpcionales()
    {
        return $this->Opcionales;
    }
    /**
     * Set Opcionales value
     * @param \Sura\Services\Autoclick\ArrayType\ArrayOfOpcional $opcionales
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setOpcionales(\Sura\Services\Autoclick\ArrayType\ArrayOfOpcional $opcionales = null)
    {
        $this->Opcionales = $opcionales;
        return $this;
    }
    /**
     * Get codigoDeducible value
     * @return int|null
     */
    public function getCodigoDeducible()
    {
        return $this->codigoDeducible;
    }
    /**
     * Set codigoDeducible value
     * @param int $codigoDeducible
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setCodigoDeducible($codigoDeducible = null)
    {
        // validation for constraint: int
        if (!is_null($codigoDeducible) && !is_numeric($codigoDeducible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoDeducible)), __LINE__);
        }
        $this->codigoDeducible = $codigoDeducible;
        return $this;
    }
    /**
     * Get deducible value
     * @return string|null
     */
    public function getDeducible()
    {
        return $this->deducible;
    }
    /**
     * Set deducible value
     * @param string $deducible
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setDeducible($deducible = null)
    {
        // validation for constraint: string
        if (!is_null($deducible) && !is_string($deducible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deducible)), __LINE__);
        }
        $this->deducible = $deducible;
        return $this;
    }
    /**
     * Get esPrimaMinima value
     * @return bool|null
     */
    public function getEsPrimaMinima()
    {
        return $this->esPrimaMinima;
    }
    /**
     * Set esPrimaMinima value
     * @param bool $esPrimaMinima
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setEsPrimaMinima($esPrimaMinima = null)
    {
        // validation for constraint: boolean
        if (!is_null($esPrimaMinima) && !is_bool($esPrimaMinima)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($esPrimaMinima)), __LINE__);
        }
        $this->esPrimaMinima = $esPrimaMinima;
        return $this;
    }
    /**
     * Get nombrePlan value
     * @return string|null
     */
    public function getNombrePlan()
    {
        return $this->nombrePlan;
    }
    /**
     * Set nombrePlan value
     * @param string $nombrePlan
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setNombrePlan($nombrePlan = null)
    {
        // validation for constraint: string
        if (!is_null($nombrePlan) && !is_string($nombrePlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombrePlan)), __LINE__);
        }
        $this->nombrePlan = $nombrePlan;
        return $this;
    }
    /**
     * Get plan value
     * @return string|null
     */
    public function getPlan()
    {
        return $this->plan;
    }
    /**
     * Set plan value
     * @param string $plan
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setPlan($plan = null)
    {
        // validation for constraint: string
        if (!is_null($plan) && !is_string($plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plan)), __LINE__);
        }
        $this->plan = $plan;
        return $this;
    }
    /**
     * Get valorEnPeso value
     * @return int|null
     */
    public function getValorEnPeso()
    {
        return $this->valorEnPeso;
    }
    /**
     * Set valorEnPeso value
     * @param int $valorEnPeso
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setValorEnPeso($valorEnPeso = null)
    {
        // validation for constraint: int
        if (!is_null($valorEnPeso) && !is_numeric($valorEnPeso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($valorEnPeso)), __LINE__);
        }
        $this->valorEnPeso = $valorEnPeso;
        return $this;
    }
    /**
     * Get valorEnUf value
     * @return float|null
     */
    public function getValorEnUf()
    {
        return $this->valorEnUf;
    }
    /**
     * Set valorEnUf value
     * @param float $valorEnUf
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setValorEnUf($valorEnUf = null)
    {
        $this->valorEnUf = $valorEnUf;
        return $this;
    }
    /**
     * Get valorUf value
     * @return float|null
     */
    public function getValorUf()
    {
        return $this->valorUf;
    }
    /**
     * Set valorUf value
     * @param float $valorUf
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public function setValorUf($valorUf = null)
    {
        $this->valorUf = $valorUf;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Services\Autoclick\StructType\Deducible
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
