<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolizaExternaPlanPagoModel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PolizaExternaPlanPagoModel
 * @subpackage Structs
 */
class PolizaExternaPlanPagoModel extends AbstractStructBase
{
    /**
     * The PAC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPACModel
     */
    public $PAC;
    /**
     * The PAT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPATModel
     */
    public $PAT;
    /**
     * The diaVencimiento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $diaVencimiento;
    /**
     * The formaPago
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $formaPago;
    /**
     * The numeroCuotas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroCuotas;
    /**
     * Constructor method for PolizaExternaPlanPagoModel
     * @uses PolizaExternaPlanPagoModel::setPAC()
     * @uses PolizaExternaPlanPagoModel::setPAT()
     * @uses PolizaExternaPlanPagoModel::setDiaVencimiento()
     * @uses PolizaExternaPlanPagoModel::setFormaPago()
     * @uses PolizaExternaPlanPagoModel::setNumeroCuotas()
     * @param \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPACModel $pAC
     * @param \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPATModel $pAT
     * @param string $diaVencimiento
     * @param string $formaPago
     * @param int $numeroCuotas
     */
    public function __construct(\Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPACModel $pAC = null, \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPATModel $pAT = null, $diaVencimiento = null, $formaPago = null, $numeroCuotas = null)
    {
        $this
            ->setPAC($pAC)
            ->setPAT($pAT)
            ->setDiaVencimiento($diaVencimiento)
            ->setFormaPago($formaPago)
            ->setNumeroCuotas($numeroCuotas);
    }
    /**
     * Get PAC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPACModel|null
     */
    public function getPAC()
    {
        return isset($this->PAC) ? $this->PAC : null;
    }
    /**
     * Set PAC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPACModel $pAC
     * @return \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public function setPAC(\Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPACModel $pAC = null)
    {
        if (is_null($pAC) || (is_array($pAC) && empty($pAC))) {
            unset($this->PAC);
        } else {
            $this->PAC = $pAC;
        }
        return $this;
    }
    /**
     * Get PAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPATModel|null
     */
    public function getPAT()
    {
        return isset($this->PAT) ? $this->PAT : null;
    }
    /**
     * Set PAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPATModel $pAT
     * @return \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public function setPAT(\Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoPATModel $pAT = null)
    {
        if (is_null($pAT) || (is_array($pAT) && empty($pAT))) {
            unset($this->PAT);
        } else {
            $this->PAT = $pAT;
        }
        return $this;
    }
    /**
     * Get diaVencimiento value
     * @return string|null
     */
    public function getDiaVencimiento()
    {
        return $this->diaVencimiento;
    }
    /**
     * Set diaVencimiento value
     * @uses \Sura\Services\Autoclick\EnumType\DiaPagos::valueIsValid()
     * @uses \Sura\Services\Autoclick\EnumType\DiaPagos::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $diaVencimiento
     * @return \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public function setDiaVencimiento($diaVencimiento = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Services\Autoclick\EnumType\DiaPagos::valueIsValid($diaVencimiento)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $diaVencimiento, implode(', ', \Sura\Services\Autoclick\EnumType\DiaPagos::getValidValues())), __LINE__);
        }
        $this->diaVencimiento = $diaVencimiento;
        return $this;
    }
    /**
     * Get formaPago value
     * @return string|null
     */
    public function getFormaPago()
    {
        return $this->formaPago;
    }
    /**
     * Set formaPago value
     * @uses \Sura\Services\Autoclick\EnumType\FormaPago::valueIsValid()
     * @uses \Sura\Services\Autoclick\EnumType\FormaPago::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formaPago
     * @return \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public function setFormaPago($formaPago = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Services\Autoclick\EnumType\FormaPago::valueIsValid($formaPago)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $formaPago, implode(', ', \Sura\Services\Autoclick\EnumType\FormaPago::getValidValues())), __LINE__);
        }
        $this->formaPago = $formaPago;
        return $this;
    }
    /**
     * Get numeroCuotas value
     * @return int|null
     */
    public function getNumeroCuotas()
    {
        return $this->numeroCuotas;
    }
    /**
     * Set numeroCuotas value
     * @param int $numeroCuotas
     * @return \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public function setNumeroCuotas($numeroCuotas = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCuotas) && !is_numeric($numeroCuotas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroCuotas)), __LINE__);
        }
        $this->numeroCuotas = $numeroCuotas;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Services\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
