<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeducibleCoberturaModel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DeducibleCoberturaModel
 * @subpackage Structs
 */
class DeducibleCoberturaModel extends AbstractStructBase
{
    /**
     * The Cobertura
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cobertura;
    /**
     * The EsExenta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EsExenta;
    /**
     * The MontoAsegurado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MontoAsegurado;
    /**
     * Constructor method for DeducibleCoberturaModel
     * @uses DeducibleCoberturaModel::setCobertura()
     * @uses DeducibleCoberturaModel::setEsExenta()
     * @uses DeducibleCoberturaModel::setMontoAsegurado()
     * @param string $cobertura
     * @param bool $esExenta
     * @param float $montoAsegurado
     */
    public function __construct($cobertura = null, $esExenta = null, $montoAsegurado = null)
    {
        $this
            ->setCobertura($cobertura)
            ->setEsExenta($esExenta)
            ->setMontoAsegurado($montoAsegurado);
    }
    /**
     * Get Cobertura value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCobertura()
    {
        return isset($this->Cobertura) ? $this->Cobertura : null;
    }
    /**
     * Set Cobertura value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cobertura
     * @return \Sura\Services\Autoclick\StructType\DeducibleCoberturaModel
     */
    public function setCobertura($cobertura = null)
    {
        // validation for constraint: string
        if (!is_null($cobertura) && !is_string($cobertura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cobertura)), __LINE__);
        }
        if (is_null($cobertura) || (is_array($cobertura) && empty($cobertura))) {
            unset($this->Cobertura);
        } else {
            $this->Cobertura = $cobertura;
        }
        return $this;
    }
    /**
     * Get EsExenta value
     * @return bool|null
     */
    public function getEsExenta()
    {
        return $this->EsExenta;
    }
    /**
     * Set EsExenta value
     * @param bool $esExenta
     * @return \Sura\Services\Autoclick\StructType\DeducibleCoberturaModel
     */
    public function setEsExenta($esExenta = null)
    {
        // validation for constraint: boolean
        if (!is_null($esExenta) && !is_bool($esExenta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($esExenta)), __LINE__);
        }
        $this->EsExenta = $esExenta;
        return $this;
    }
    /**
     * Get MontoAsegurado value
     * @return float|null
     */
    public function getMontoAsegurado()
    {
        return $this->MontoAsegurado;
    }
    /**
     * Set MontoAsegurado value
     * @param float $montoAsegurado
     * @return \Sura\Services\Autoclick\StructType\DeducibleCoberturaModel
     */
    public function setMontoAsegurado($montoAsegurado = null)
    {
        $this->MontoAsegurado = $montoAsegurado;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Services\Autoclick\StructType\DeducibleCoberturaModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
