<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeducibleCobertura StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DeducibleCobertura
 * @subpackage Structs
 */
class DeducibleCobertura extends AbstractStructBase
{
    /**
     * The cobertura
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cobertura;
    /**
     * The esExenta
     * @var bool
     */
    public $esExenta;
    /**
     * The montoAsegurado
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $montoAsegurado;
    /**
     * Constructor method for DeducibleCobertura
     * @uses DeducibleCobertura::setCobertura()
     * @uses DeducibleCobertura::setEsExenta()
     * @uses DeducibleCobertura::setMontoAsegurado()
     * @param string $cobertura
     * @param bool $esExenta
     * @param string $montoAsegurado
     */
    public function __construct($cobertura = null, $esExenta = null, $montoAsegurado = null)
    {
        $this
            ->setCobertura($cobertura)
            ->setEsExenta($esExenta)
            ->setMontoAsegurado($montoAsegurado);
    }
    /**
     * Get cobertura value
     * @return string|null
     */
    public function getCobertura()
    {
        return $this->cobertura;
    }
    /**
     * Set cobertura value
     * @param string $cobertura
     * @return \Sura\Services\Autoclick\StructType\DeducibleCobertura
     */
    public function setCobertura($cobertura = null)
    {
        // validation for constraint: string
        if (!is_null($cobertura) && !is_string($cobertura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cobertura)), __LINE__);
        }
        $this->cobertura = $cobertura;
        return $this;
    }
    /**
     * Get esExenta value
     * @return bool|null
     */
    public function getEsExenta()
    {
        return $this->esExenta;
    }
    /**
     * Set esExenta value
     * @param bool $esExenta
     * @return \Sura\Services\Autoclick\StructType\DeducibleCobertura
     */
    public function setEsExenta($esExenta = null)
    {
        // validation for constraint: boolean
        if (!is_null($esExenta) && !is_bool($esExenta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($esExenta)), __LINE__);
        }
        $this->esExenta = $esExenta;
        return $this;
    }
    /**
     * Get montoAsegurado value
     * @return string|null
     */
    public function getMontoAsegurado()
    {
        return $this->montoAsegurado;
    }
    /**
     * Set montoAsegurado value
     * @param string $montoAsegurado
     * @return \Sura\Services\Autoclick\StructType\DeducibleCobertura
     */
    public function setMontoAsegurado($montoAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($montoAsegurado) && !is_string($montoAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($montoAsegurado)), __LINE__);
        }
        $this->montoAsegurado = $montoAsegurado;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Services\Autoclick\StructType\DeducibleCobertura
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
