<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeducibleBase StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DeducibleBase
 * @subpackage Structs
 */
class DeducibleBase extends AbstractStructBase
{
    /**
     * The Opcionales
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Sura\Services\Autoclick\ArrayType\ArrayOfOpcional
     */
    public $Opcionales;
    /**
     * The codigoDeducible
     * @var int
     */
    public $codigoDeducible;
    /**
     * The deducible
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deducible;
    /**
     * The nombrePlan
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nombrePlan;
    /**
     * The valorEnPeso
     * @var int
     */
    public $valorEnPeso;
    /**
     * The valorEnUf
     * @var float
     */
    public $valorEnUf;
    /**
     * The valorUf
     * @var float
     */
    public $valorUf;
    /**
     * Constructor method for DeducibleBase
     * @uses DeducibleBase::setOpcionales()
     * @uses DeducibleBase::setCodigoDeducible()
     * @uses DeducibleBase::setDeducible()
     * @uses DeducibleBase::setNombrePlan()
     * @uses DeducibleBase::setValorEnPeso()
     * @uses DeducibleBase::setValorEnUf()
     * @uses DeducibleBase::setValorUf()
     * @param \Sura\Services\Autoclick\ArrayType\ArrayOfOpcional $opcionales
     * @param int $codigoDeducible
     * @param string $deducible
     * @param string $nombrePlan
     * @param int $valorEnPeso
     * @param float $valorEnUf
     * @param float $valorUf
     */
    public function __construct(\Sura\Services\Autoclick\ArrayType\ArrayOfOpcional $opcionales = null, $codigoDeducible = null, $deducible = null, $nombrePlan = null, $valorEnPeso = null, $valorEnUf = null, $valorUf = null)
    {
        $this
            ->setOpcionales($opcionales)
            ->setCodigoDeducible($codigoDeducible)
            ->setDeducible($deducible)
            ->setNombrePlan($nombrePlan)
            ->setValorEnPeso($valorEnPeso)
            ->setValorEnUf($valorEnUf)
            ->setValorUf($valorUf);
    }
    /**
     * Get Opcionales value
     * @return \Sura\Services\Autoclick\ArrayType\ArrayOfOpcional|null
     */
    public function getOpcionales()
    {
        return $this->Opcionales;
    }
    /**
     * Set Opcionales value
     * @param \Sura\Services\Autoclick\ArrayType\ArrayOfOpcional $opcionales
     * @return \Sura\Services\Autoclick\StructType\DeducibleBase
     */
    public function setOpcionales(\Sura\Services\Autoclick\ArrayType\ArrayOfOpcional $opcionales = null)
    {
        $this->Opcionales = $opcionales;
        return $this;
    }
    /**
     * Get codigoDeducible value
     * @return int|null
     */
    public function getCodigoDeducible()
    {
        return $this->codigoDeducible;
    }
    /**
     * Set codigoDeducible value
     * @param int $codigoDeducible
     * @return \Sura\Services\Autoclick\StructType\DeducibleBase
     */
    public function setCodigoDeducible($codigoDeducible = null)
    {
        // validation for constraint: int
        if (!is_null($codigoDeducible) && !is_numeric($codigoDeducible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoDeducible)), __LINE__);
        }
        $this->codigoDeducible = $codigoDeducible;
        return $this;
    }
    /**
     * Get deducible value
     * @return string|null
     */
    public function getDeducible()
    {
        return $this->deducible;
    }
    /**
     * Set deducible value
     * @param string $deducible
     * @return \Sura\Services\Autoclick\StructType\DeducibleBase
     */
    public function setDeducible($deducible = null)
    {
        // validation for constraint: string
        if (!is_null($deducible) && !is_string($deducible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deducible)), __LINE__);
        }
        $this->deducible = $deducible;
        return $this;
    }
    /**
     * Get nombrePlan value
     * @return string|null
     */
    public function getNombrePlan()
    {
        return $this->nombrePlan;
    }
    /**
     * Set nombrePlan value
     * @param string $nombrePlan
     * @return \Sura\Services\Autoclick\StructType\DeducibleBase
     */
    public function setNombrePlan($nombrePlan = null)
    {
        // validation for constraint: string
        if (!is_null($nombrePlan) && !is_string($nombrePlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombrePlan)), __LINE__);
        }
        $this->nombrePlan = $nombrePlan;
        return $this;
    }
    /**
     * Get valorEnPeso value
     * @return int|null
     */
    public function getValorEnPeso()
    {
        return $this->valorEnPeso;
    }
    /**
     * Set valorEnPeso value
     * @param int $valorEnPeso
     * @return \Sura\Services\Autoclick\StructType\DeducibleBase
     */
    public function setValorEnPeso($valorEnPeso = null)
    {
        // validation for constraint: int
        if (!is_null($valorEnPeso) && !is_numeric($valorEnPeso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($valorEnPeso)), __LINE__);
        }
        $this->valorEnPeso = $valorEnPeso;
        return $this;
    }
    /**
     * Get valorEnUf value
     * @return float|null
     */
    public function getValorEnUf()
    {
        return $this->valorEnUf;
    }
    /**
     * Set valorEnUf value
     * @param float $valorEnUf
     * @return \Sura\Services\Autoclick\StructType\DeducibleBase
     */
    public function setValorEnUf($valorEnUf = null)
    {
        $this->valorEnUf = $valorEnUf;
        return $this;
    }
    /**
     * Get valorUf value
     * @return float|null
     */
    public function getValorUf()
    {
        return $this->valorUf;
    }
    /**
     * Set valorUf value
     * @param float $valorUf
     * @return \Sura\Services\Autoclick\StructType\DeducibleBase
     */
    public function setValorUf($valorUf = null)
    {
        $this->valorUf = $valorUf;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Services\Autoclick\StructType\DeducibleBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
