<?php

namespace Sura\Services\Autoclick\EnumType;

/**
 * This class stands for FormaPago EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FormaPago
 * @subpackage Enumerations
 */
class FormaPago
{
    /**
     * Constant for value 'SinFormaPago'
     * @return string 'SinFormaPago'
     */
    const VALUE_SIN_FORMA_PAGO = 'SinFormaPago';
    /**
     * Constant for value 'EstadodeCuenta'
     * @return string 'EstadodeCuenta'
     */
    const VALUE_ESTADODE_CUENTA = 'EstadodeCuenta';
    /**
     * Constant for value 'PAC'
     * @return string 'PAC'
     */
    const VALUE_PAC = 'PAC';
    /**
     * Constant for value 'PAT'
     * @return string 'PAT'
     */
    const VALUE_PAT = 'PAT';
    /**
     * Constant for value 'RecaudacionMasiva'
     * @return string 'RecaudacionMasiva'
     */
    const VALUE_RECAUDACION_MASIVA = 'RecaudacionMasiva';
    /**
     * The cantidadCuotas
     * @var int
     */
    public $cantidadCuotas;
    /**
     * The formaPago
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $formaPago;
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SIN_FORMA_PAGO
     * @uses self::VALUE_ESTADODE_CUENTA
     * @uses self::VALUE_PAC
     * @uses self::VALUE_PAT
     * @uses self::VALUE_RECAUDACION_MASIVA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SIN_FORMA_PAGO,
            self::VALUE_ESTADODE_CUENTA,
            self::VALUE_PAC,
            self::VALUE_PAT,
            self::VALUE_RECAUDACION_MASIVA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
