<?php

namespace Sura\Services\Autoclick\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCuota ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCuota
 * @subpackage Arrays
 */
class ArrayOfCuota extends AbstractStructArrayBase
{
    /**
     * The Cuota
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Services\Autoclick\StructType\Cuota[]
     */
    public $Cuota;
    /**
     * Constructor method for ArrayOfCuota
     * @uses ArrayOfCuota::setCuota()
     * @param \Sura\Services\Autoclick\StructType\Cuota[] $cuota
     */
    public function __construct(array $cuota = array())
    {
        $this
            ->setCuota($cuota);
    }
    /**
     * Get Cuota value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Services\Autoclick\StructType\Cuota[]|null
     */
    public function getCuota()
    {
        return isset($this->Cuota) ? $this->Cuota : null;
    }
    /**
     * Set Cuota value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Sura\Services\Autoclick\StructType\Cuota[] $cuota
     * @return \Sura\Services\Autoclick\ArrayType\ArrayOfCuota
     */
    public function setCuota(array $cuota = array())
    {
        foreach ($cuota as $arrayOfCuotaCuotaItem) {
            // validation for constraint: itemType
            if (!$arrayOfCuotaCuotaItem instanceof \Sura\Services\Autoclick\StructType\Cuota) {
                throw new \InvalidArgumentException(sprintf('The Cuota property can only contain items of \Sura\Services\Autoclick\StructType\Cuota, "%s" given', is_object($arrayOfCuotaCuotaItem) ? get_class($arrayOfCuotaCuotaItem) : gettype($arrayOfCuotaCuotaItem)), __LINE__);
            }
        }
        if (is_null($cuota) || (is_array($cuota) && empty($cuota))) {
            unset($this->Cuota);
        } else {
            $this->Cuota = $cuota;
        }
        return $this;
    }
    /**
     * Add item to Cuota value
     * @throws \InvalidArgumentException
     * @param \Sura\Services\Autoclick\StructType\Cuota $item
     * @return \Sura\Services\Autoclick\ArrayType\ArrayOfCuota
     */
    public function addToCuota(\Sura\Services\Autoclick\StructType\Cuota $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sura\Services\Autoclick\StructType\Cuota) {
            throw new \InvalidArgumentException(sprintf('The Cuota property can only contain items of \Sura\Services\Autoclick\StructType\Cuota, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Cuota[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Sura\Services\Autoclick\StructType\Cuota|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Sura\Services\Autoclick\StructType\Cuota|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Sura\Services\Autoclick\StructType\Cuota|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Sura\Services\Autoclick\StructType\Cuota|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Sura\Services\Autoclick\StructType\Cuota|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Cuota
     */
    public function getAttributeName()
    {
        return 'Cuota';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Services\Autoclick\ArrayType\ArrayOfCuota
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
