<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Opcional StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Opcional
 * @subpackage Structs
 */
class Opcional extends AbstractStructBase
{
    /**
     * The OpcionalID
     * @var int
     */
    public $OpcionalID;
    /**
     * The descripcion
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $descripcion;
    /**
     * The prima
     * @var float
     */
    public $prima;
    /**
     * The factor
     * @var float
     */
    public $factor;
    /**
     * Constructor method for Opcional
     * @uses Opcional::setOpcionalID()
     * @uses Opcional::setDescripcion()
     * @uses Opcional::setPrima()
     * @uses Opcional::setFactor()
     * @param int $opcionalID
     * @param string $descripcion
     * @param float $prima
     * @param float $factor
     */
    public function __construct($opcionalID = null, $descripcion = null, $prima = null, $factor = null)
    {
        $this
            ->setOpcionalID($opcionalID)
            ->setDescripcion($descripcion)
            ->setPrima($prima)
            ->setFactor($factor);
    }
    /**
     * Get OpcionalID value
     * @return int|null
     */
    public function getOpcionalID()
    {
        return $this->OpcionalID;
    }
    /**
     * Set OpcionalID value
     * @param int $opcionalID
     * @return \Sura\Services\Autoclick\StructType\Opcional
     */
    public function setOpcionalID($opcionalID = null)
    {
        // validation for constraint: int
        if (!is_null($opcionalID) && !is_numeric($opcionalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($opcionalID)), __LINE__);
        }
        $this->OpcionalID = $opcionalID;
        return $this;
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \Sura\Services\Autoclick\StructType\Opcional
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
    /**
     * Get prima value
     * @return float|null
     */
    public function getPrima()
    {
        return $this->prima;
    }
    /**
     * Set prima value
     * @param float $prima
     * @return \Sura\Services\Autoclick\StructType\Opcional
     */
    public function setPrima($prima = null)
    {
        $this->prima = $prima;
        return $this;
    }
    /**
     * Get factor value
     * @return float|null
     */
    public function getFactor()
    {
        return $this->factor;
    }
    /**
     * Set factor value
     * @param float $factor
     * @return \Sura\Services\Autoclick\StructType\Opcional
     */
    public function setFactor($factor = null)
    {
        $this->factor = $factor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Services\Autoclick\StructType\Opcional
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
