<?php

namespace Sura\Services\Autoclick\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Sets the DatosTransaccion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sura\Services\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDatosTransaccion(\Sura\Services\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion, $nameSpace = 'http://ws.rsa.cl/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DatosTransaccion', $datosTransaccion, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ConsultaEstadoCotizacion
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\ConsultaEstadoCotizacionRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\ConsultaEstadoCotizacionResponse|bool
     */
    public function ConsultaEstadoCotizacion(\Sura\Services\Autoclick\StructType\ConsultaEstadoCotizacionRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConsultaEstadoCotizacion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaSiniestralidad
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\ConsultaSiniestralidadRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\ConsultaSiniestralidadResponse|bool
     */
    public function ConsultaSiniestralidad(\Sura\Services\Autoclick\StructType\ConsultaSiniestralidadRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConsultaSiniestralidad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaPlanPago
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\ConsultaPlanPagoRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\ConsultaPlanPagoResponse|bool
     */
    public function ConsultaPlanPago(\Sura\Services\Autoclick\StructType\ConsultaPlanPagoRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConsultaPlanPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaContactabilidad
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\ConsultaContactabilidadRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\ConsultaContactabilidadResponse|bool
     */
    public function ConsultaContactabilidad(\Sura\Services\Autoclick\StructType\ConsultaContactabilidadRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConsultaContactabilidad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaDocumentos
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Services\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\ConsultaDocumentosRequest $parameters
     * @return \Sura\Services\Autoclick\StructType\ConsultaDocumentosResponse|bool
     */
    public function ConsultaDocumentos(\Sura\Services\Autoclick\StructType\ConsultaDocumentosRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConsultaDocumentos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaPolizaIndividual
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Services\Autoclick\StructType\ConsultaPolizaIndividual $parameters
     * @return \Sura\Services\Autoclick\StructType\ConsultaPolizaIndividualResponse|bool
     */
    public function ConsultaPolizaIndividual(\Sura\Services\Autoclick\StructType\ConsultaPolizaIndividual $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConsultaPolizaIndividual($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sura\Services\Autoclick\StructType\ConsultaContactabilidadResponse|\Sura\Services\Autoclick\StructType\ConsultaDocumentosResponse|\Sura\Services\Autoclick\StructType\ConsultaEstadoCotizacionResponse|\Sura\Services\Autoclick\StructType\ConsultaPlanPagoResponse|\Sura\Services\Autoclick\StructType\ConsultaPolizaIndividualResponse|\Sura\Services\Autoclick\StructType\ConsultaSiniestralidadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
