<?php

namespace Sura\Services\Autoclick\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for OpcionalTaller EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OpcionalTaller
 * @subpackage Enumerations
 */
class OpcionalTaller extends AbstractStructEnumBase
{
    /**
     * Constant for value 'TallerdeMarca'
     * @return string 'TallerdeMarca'
     */
    const VALUE_TALLERDE_MARCA = 'TallerdeMarca';
    /**
     * Constant for value 'TallerGarantia'
     * @return string 'TallerGarantia'
     */
    const VALUE_TALLER_GARANTIA = 'TallerGarantia';
    /**
     * Constant for value 'MultiMarca'
     * @return string 'MultiMarca'
     */
    const VALUE_MULTI_MARCA = 'MultiMarca';
    /**
     * Constant for value 'SinOpcional'
     * @return string 'SinOpcional'
     */
    const VALUE_SIN_OPCIONAL = 'SinOpcional';
    /**
     * Return allowed values
     * @uses self::VALUE_TALLERDE_MARCA
     * @uses self::VALUE_TALLER_GARANTIA
     * @uses self::VALUE_MULTI_MARCA
     * @uses self::VALUE_SIN_OPCIONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TALLERDE_MARCA,
            self::VALUE_TALLER_GARANTIA,
            self::VALUE_MULTI_MARCA,
            self::VALUE_SIN_OPCIONAL,
        );
    }
}
