<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cuota StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Cuota
 * @subpackage Structs
 */
class Cuota extends AbstractStructBase
{
    /**
     * The cantidadCuota
     * @var int
     */
    public $cantidadCuota;
    /**
     * The valorUf
     * @var float
     */
    public $valorUf;
    /**
     * Constructor method for Cuota
     * @uses Cuota::setCantidadCuota()
     * @uses Cuota::setValorUf()
     * @param int $cantidadCuota
     * @param float $valorUf
     */
    public function __construct($cantidadCuota = null, $valorUf = null)
    {
        $this
            ->setCantidadCuota($cantidadCuota)
            ->setValorUf($valorUf);
    }
    /**
     * Get cantidadCuota value
     * @return int|null
     */
    public function getCantidadCuota()
    {
        return $this->cantidadCuota;
    }
    /**
     * Set cantidadCuota value
     * @param int $cantidadCuota
     * @return \Sura\Services\Autoclick\StructType\Cuota
     */
    public function setCantidadCuota($cantidadCuota = null)
    {
        // validation for constraint: int
        if (!is_null($cantidadCuota) && !(is_int($cantidadCuota) || ctype_digit($cantidadCuota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantidadCuota, true), gettype($cantidadCuota)), __LINE__);
        }
        $this->cantidadCuota = $cantidadCuota;
        return $this;
    }
    /**
     * Get valorUf value
     * @return float|null
     */
    public function getValorUf()
    {
        return $this->valorUf;
    }
    /**
     * Set valorUf value
     * @param float $valorUf
     * @return \Sura\Services\Autoclick\StructType\Cuota
     */
    public function setValorUf($valorUf = null)
    {
        // validation for constraint: float
        if (!is_null($valorUf) && !(is_float($valorUf) || is_numeric($valorUf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorUf, true), gettype($valorUf)), __LINE__);
        }
        $this->valorUf = $valorUf;
        return $this;
    }
}
