<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultaPolizaIndividualRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConsultaPolizaIndividualRequest
 * @subpackage Structs
 */
class ConsultaPolizaIndividualRequest extends AbstractStructBase
{
    /**
     * The FechaConsulta
     * @var string
     */
    public $FechaConsulta;
    /**
     * The NroSeguro
     * @var int
     */
    public $NroSeguro;
    /**
     * The RutAsegurado
     * @var int
     */
    public $RutAsegurado;
    /**
     * The RutCorredor
     * @var int
     */
    public $RutCorredor;
    /**
     * The RutTitular
     * @var int
     */
    public $RutTitular;
    /**
     * Constructor method for ConsultaPolizaIndividualRequest
     * @uses ConsultaPolizaIndividualRequest::setFechaConsulta()
     * @uses ConsultaPolizaIndividualRequest::setNroSeguro()
     * @uses ConsultaPolizaIndividualRequest::setRutAsegurado()
     * @uses ConsultaPolizaIndividualRequest::setRutCorredor()
     * @uses ConsultaPolizaIndividualRequest::setRutTitular()
     * @param string $fechaConsulta
     * @param int $nroSeguro
     * @param int $rutAsegurado
     * @param int $rutCorredor
     * @param int $rutTitular
     */
    public function __construct($fechaConsulta = null, $nroSeguro = null, $rutAsegurado = null, $rutCorredor = null, $rutTitular = null)
    {
        $this
            ->setFechaConsulta($fechaConsulta)
            ->setNroSeguro($nroSeguro)
            ->setRutAsegurado($rutAsegurado)
            ->setRutCorredor($rutCorredor)
            ->setRutTitular($rutTitular);
    }
    /**
     * Get FechaConsulta value
     * @return string|null
     */
    public function getFechaConsulta()
    {
        return $this->FechaConsulta;
    }
    /**
     * Set FechaConsulta value
     * @param string $fechaConsulta
     * @return \Sura\Services\Autoclick\StructType\ConsultaPolizaIndividualRequest
     */
    public function setFechaConsulta($fechaConsulta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaConsulta) && !is_string($fechaConsulta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaConsulta, true), gettype($fechaConsulta)), __LINE__);
        }
        $this->FechaConsulta = $fechaConsulta;
        return $this;
    }
    /**
     * Get NroSeguro value
     * @return int|null
     */
    public function getNroSeguro()
    {
        return $this->NroSeguro;
    }
    /**
     * Set NroSeguro value
     * @param int $nroSeguro
     * @return \Sura\Services\Autoclick\StructType\ConsultaPolizaIndividualRequest
     */
    public function setNroSeguro($nroSeguro = null)
    {
        // validation for constraint: int
        if (!is_null($nroSeguro) && !(is_int($nroSeguro) || ctype_digit($nroSeguro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nroSeguro, true), gettype($nroSeguro)), __LINE__);
        }
        $this->NroSeguro = $nroSeguro;
        return $this;
    }
    /**
     * Get RutAsegurado value
     * @return int|null
     */
    public function getRutAsegurado()
    {
        return $this->RutAsegurado;
    }
    /**
     * Set RutAsegurado value
     * @param int $rutAsegurado
     * @return \Sura\Services\Autoclick\StructType\ConsultaPolizaIndividualRequest
     */
    public function setRutAsegurado($rutAsegurado = null)
    {
        // validation for constraint: int
        if (!is_null($rutAsegurado) && !(is_int($rutAsegurado) || ctype_digit($rutAsegurado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rutAsegurado, true), gettype($rutAsegurado)), __LINE__);
        }
        $this->RutAsegurado = $rutAsegurado;
        return $this;
    }
    /**
     * Get RutCorredor value
     * @return int|null
     */
    public function getRutCorredor()
    {
        return $this->RutCorredor;
    }
    /**
     * Set RutCorredor value
     * @param int $rutCorredor
     * @return \Sura\Services\Autoclick\StructType\ConsultaPolizaIndividualRequest
     */
    public function setRutCorredor($rutCorredor = null)
    {
        // validation for constraint: int
        if (!is_null($rutCorredor) && !(is_int($rutCorredor) || ctype_digit($rutCorredor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rutCorredor, true), gettype($rutCorredor)), __LINE__);
        }
        $this->RutCorredor = $rutCorredor;
        return $this;
    }
    /**
     * Get RutTitular value
     * @return int|null
     */
    public function getRutTitular()
    {
        return $this->RutTitular;
    }
    /**
     * Set RutTitular value
     * @param int $rutTitular
     * @return \Sura\Services\Autoclick\StructType\ConsultaPolizaIndividualRequest
     */
    public function setRutTitular($rutTitular = null)
    {
        // validation for constraint: int
        if (!is_null($rutTitular) && !(is_int($rutTitular) || ctype_digit($rutTitular))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rutTitular, true), gettype($rutTitular)), __LINE__);
        }
        $this->RutTitular = $rutTitular;
        return $this;
    }
}
