<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Opcionales StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Opcionales
 * @subpackage Structs
 */
class Opcionales extends AbstractStructBase
{
    /**
     * The asistencias
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $asistencias;
    /**
     * The autoReemplazo
     * @var string
     */
    public $autoReemplazo;
    /**
     * The rCExceso
     * @var string
     */
    public $rCExceso;
    /**
     * The taller
     * @var string
     */
    public $taller;
    /**
     * Constructor method for Opcionales
     * @uses Opcionales::setAsistencias()
     * @uses Opcionales::setAutoReemplazo()
     * @uses Opcionales::setRCExceso()
     * @uses Opcionales::setTaller()
     * @param string $asistencias
     * @param string $autoReemplazo
     * @param string $rCExceso
     * @param string $taller
     */
    public function __construct($asistencias = null, $autoReemplazo = null, $rCExceso = null, $taller = null)
    {
        $this
            ->setAsistencias($asistencias)
            ->setAutoReemplazo($autoReemplazo)
            ->setRCExceso($rCExceso)
            ->setTaller($taller);
    }
    /**
     * Get asistencias value
     * @return string|null
     */
    public function getAsistencias()
    {
        return $this->asistencias;
    }
    /**
     * Set asistencias value
     * @uses \Sura\Services\Autoclick\EnumType\OpcionalAsistencias::valueIsValid()
     * @uses \Sura\Services\Autoclick\EnumType\OpcionalAsistencias::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $asistencias
     * @return \Sura\Services\Autoclick\StructType\Opcionales
     */
    public function setAsistencias($asistencias = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Services\Autoclick\EnumType\OpcionalAsistencias::valueIsValid($asistencias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sura\Services\Autoclick\EnumType\OpcionalAsistencias', is_array($asistencias) ? implode(', ', $asistencias) : var_export($asistencias, true), implode(', ', \Sura\Services\Autoclick\EnumType\OpcionalAsistencias::getValidValues())), __LINE__);
        }
        $this->asistencias = $asistencias;
        return $this;
    }
    /**
     * Get autoReemplazo value
     * @return string|null
     */
    public function getAutoReemplazo()
    {
        return $this->autoReemplazo;
    }
    /**
     * Set autoReemplazo value
     * @uses \Sura\Services\Autoclick\EnumType\OpcionalAutoReemplazo::valueIsValid()
     * @uses \Sura\Services\Autoclick\EnumType\OpcionalAutoReemplazo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoReemplazo
     * @return \Sura\Services\Autoclick\StructType\Opcionales
     */
    public function setAutoReemplazo($autoReemplazo = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Services\Autoclick\EnumType\OpcionalAutoReemplazo::valueIsValid($autoReemplazo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sura\Services\Autoclick\EnumType\OpcionalAutoReemplazo', is_array($autoReemplazo) ? implode(', ', $autoReemplazo) : var_export($autoReemplazo, true), implode(', ', \Sura\Services\Autoclick\EnumType\OpcionalAutoReemplazo::getValidValues())), __LINE__);
        }
        $this->autoReemplazo = $autoReemplazo;
        return $this;
    }
    /**
     * Get rCExceso value
     * @return string|null
     */
    public function getRCExceso()
    {
        return $this->rCExceso;
    }
    /**
     * Set rCExceso value
     * @uses \Sura\Services\Autoclick\EnumType\OpcionalRCExceso::valueIsValid()
     * @uses \Sura\Services\Autoclick\EnumType\OpcionalRCExceso::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rCExceso
     * @return \Sura\Services\Autoclick\StructType\Opcionales
     */
    public function setRCExceso($rCExceso = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Services\Autoclick\EnumType\OpcionalRCExceso::valueIsValid($rCExceso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sura\Services\Autoclick\EnumType\OpcionalRCExceso', is_array($rCExceso) ? implode(', ', $rCExceso) : var_export($rCExceso, true), implode(', ', \Sura\Services\Autoclick\EnumType\OpcionalRCExceso::getValidValues())), __LINE__);
        }
        $this->rCExceso = $rCExceso;
        return $this;
    }
    /**
     * Get taller value
     * @return string|null
     */
    public function getTaller()
    {
        return $this->taller;
    }
    /**
     * Set taller value
     * @uses \Sura\Services\Autoclick\EnumType\OpcionalTaller::valueIsValid()
     * @uses \Sura\Services\Autoclick\EnumType\OpcionalTaller::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taller
     * @return \Sura\Services\Autoclick\StructType\Opcionales
     */
    public function setTaller($taller = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Services\Autoclick\EnumType\OpcionalTaller::valueIsValid($taller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sura\Services\Autoclick\EnumType\OpcionalTaller', is_array($taller) ? implode(', ', $taller) : var_export($taller, true), implode(', ', \Sura\Services\Autoclick\EnumType\OpcionalTaller::getValidValues())), __LINE__);
        }
        $this->taller = $taller;
        return $this;
    }
}
