<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SolicitudInspeccionRequest StructType
 * @subpackage Structs
 */
class SolicitudInspeccionRequest extends AbstractStructBase
{
    /**
     * The InformacionSolicitudInspeccion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Services\Autoclick\StructType\InformacionSolicitudInspeccionModel
     */
    public $InformacionSolicitudInspeccion;
    /**
     * The CotizacionServicioID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CotizacionServicioID;
    /**
     * Constructor method for SolicitudInspeccionRequest
     * @uses SolicitudInspeccionRequest::setInformacionSolicitudInspeccion()
     * @uses SolicitudInspeccionRequest::setCotizacionServicioID()
     * @param \Sura\Services\Autoclick\StructType\InformacionSolicitudInspeccionModel $informacionSolicitudInspeccion
     * @param string $cotizacionServicioID
     */
    public function __construct(\Sura\Services\Autoclick\StructType\InformacionSolicitudInspeccionModel $informacionSolicitudInspeccion = null, $cotizacionServicioID = null)
    {
        $this
            ->setInformacionSolicitudInspeccion($informacionSolicitudInspeccion)
            ->setCotizacionServicioID($cotizacionServicioID);
    }
    /**
     * Get InformacionSolicitudInspeccion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Services\Autoclick\StructType\InformacionSolicitudInspeccionModel|null
     */
    public function getInformacionSolicitudInspeccion()
    {
        return isset($this->InformacionSolicitudInspeccion) ? $this->InformacionSolicitudInspeccion : null;
    }
    /**
     * Set InformacionSolicitudInspeccion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sura\Services\Autoclick\StructType\InformacionSolicitudInspeccionModel $informacionSolicitudInspeccion
     * @return \Sura\Services\Autoclick\StructType\SolicitudInspeccionRequest
     */
    public function setInformacionSolicitudInspeccion(\Sura\Services\Autoclick\StructType\InformacionSolicitudInspeccionModel $informacionSolicitudInspeccion = null)
    {
        if (is_null($informacionSolicitudInspeccion) || (is_array($informacionSolicitudInspeccion) && empty($informacionSolicitudInspeccion))) {
            unset($this->InformacionSolicitudInspeccion);
        } else {
            $this->InformacionSolicitudInspeccion = $informacionSolicitudInspeccion;
        }
        return $this;
    }
    /**
     * Get CotizacionServicioID value
     * @return string|null
     */
    public function getCotizacionServicioID()
    {
        return $this->CotizacionServicioID;
    }
    /**
     * Set CotizacionServicioID value
     * @param string $cotizacionServicioID
     * @return \Sura\Services\Autoclick\StructType\SolicitudInspeccionRequest
     */
    public function setCotizacionServicioID($cotizacionServicioID = null)
    {
        // validation for constraint: string
        if (!is_null($cotizacionServicioID) && !is_string($cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cotizacionServicioID, true), gettype($cotizacionServicioID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cotizacionServicioID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cotizacionServicioID, true)), __LINE__);
        }
        $this->CotizacionServicioID = $cotizacionServicioID;
        return $this;
    }
}
