<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultaDocumentosRequest StructType
 * @subpackage Structs
 */
class ConsultaDocumentosRequest extends AbstractStructBase
{
    /**
     * The NumeroPoliza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroPoliza;
    /**
     * Constructor method for ConsultaDocumentosRequest
     * @uses ConsultaDocumentosRequest::setNumeroPoliza()
     * @param string $numeroPoliza
     */
    public function __construct($numeroPoliza = null)
    {
        $this
            ->setNumeroPoliza($numeroPoliza);
    }
    /**
     * Get NumeroPoliza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroPoliza()
    {
        return isset($this->NumeroPoliza) ? $this->NumeroPoliza : null;
    }
    /**
     * Set NumeroPoliza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroPoliza
     * @return \Sura\Services\Autoclick\StructType\ConsultaDocumentosRequest
     */
    public function setNumeroPoliza($numeroPoliza = null)
    {
        // validation for constraint: string
        if (!is_null($numeroPoliza) && !is_string($numeroPoliza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroPoliza, true), gettype($numeroPoliza)), __LINE__);
        }
        if (is_null($numeroPoliza) || (is_array($numeroPoliza) && empty($numeroPoliza))) {
            unset($this->NumeroPoliza);
        } else {
            $this->NumeroPoliza = $numeroPoliza;
        }
        return $this;
    }
}
