<?php

namespace Sura\Services\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatosBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DatosBase
 * @subpackage Structs
 */
class DatosBase extends AbstractStructBase
{
    /**
     * The Asegurado
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Sura\Services\Autoclick\StructType\Asegurado
     */
    public $Asegurado;
    /**
     * The declaraConductorMenor30Anios
     * @var bool
     */
    public $declaraConductorMenor30Anios;
    /**
     * The formaPago
     * @var \Sura\Services\Autoclick\StructType\FormaPago
     */
    public $formaPago;
    /**
     * The recargoDescuento
     * @var string
     */
    public $recargoDescuento;
    /**
     * The valorRecargo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $valorRecargo;
    /**
     * Constructor method for DatosBase
     * @uses DatosBase::setAsegurado()
     * @uses DatosBase::setDeclaraConductorMenor30Anios()
     * @uses DatosBase::setFormaPago()
     * @uses DatosBase::setRecargoDescuento()
     * @uses DatosBase::setValorRecargo()
     * @param \Sura\Services\Autoclick\StructType\Asegurado $asegurado
     * @param bool $declaraConductorMenor30Anios
     * @param \Sura\Services\Autoclick\StructType\FormaPago $formaPago
     * @param string $recargoDescuento
     * @param string $valorRecargo
     */
    public function __construct(\Sura\Services\Autoclick\StructType\Asegurado $asegurado = null, $declaraConductorMenor30Anios = null, \Sura\Services\Autoclick\StructType\FormaPago $formaPago = null, $recargoDescuento = null, $valorRecargo = null)
    {
        $this
            ->setAsegurado($asegurado)
            ->setDeclaraConductorMenor30Anios($declaraConductorMenor30Anios)
            ->setFormaPago($formaPago)
            ->setRecargoDescuento($recargoDescuento)
            ->setValorRecargo($valorRecargo);
    }
    /**
     * Get Asegurado value
     * @return \Sura\Services\Autoclick\StructType\Asegurado|null
     */
    public function getAsegurado()
    {
        return $this->Asegurado;
    }
    /**
     * Set Asegurado value
     * @param \Sura\Services\Autoclick\StructType\Asegurado $asegurado
     * @return \Sura\Services\Autoclick\StructType\DatosBase
     */
    public function setAsegurado(\Sura\Services\Autoclick\StructType\Asegurado $asegurado = null)
    {
        $this->Asegurado = $asegurado;
        return $this;
    }
    /**
     * Get declaraConductorMenor30Anios value
     * @return bool|null
     */
    public function getDeclaraConductorMenor30Anios()
    {
        return $this->declaraConductorMenor30Anios;
    }
    /**
     * Set declaraConductorMenor30Anios value
     * @param bool $declaraConductorMenor30Anios
     * @return \Sura\Services\Autoclick\StructType\DatosBase
     */
    public function setDeclaraConductorMenor30Anios($declaraConductorMenor30Anios = null)
    {
        // validation for constraint: boolean
        if (!is_null($declaraConductorMenor30Anios) && !is_bool($declaraConductorMenor30Anios)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($declaraConductorMenor30Anios, true), gettype($declaraConductorMenor30Anios)), __LINE__);
        }
        $this->declaraConductorMenor30Anios = $declaraConductorMenor30Anios;
        return $this;
    }
    /**
     * Get formaPago value
     * @return \Sura\Services\Autoclick\StructType\FormaPago|null
     */
    public function getFormaPago()
    {
        return $this->formaPago;
    }
    /**
     * Set formaPago value
     * @param \Sura\Services\Autoclick\StructType\FormaPago $formaPago
     * @return \Sura\Services\Autoclick\StructType\DatosBase
     */
    public function setFormaPago(\Sura\Services\Autoclick\StructType\FormaPago $formaPago = null)
    {
        $this->formaPago = $formaPago;
        return $this;
    }
    /**
     * Get recargoDescuento value
     * @return string|null
     */
    public function getRecargoDescuento()
    {
        return $this->recargoDescuento;
    }
    /**
     * Set recargoDescuento value
     * @uses \Sura\Services\Autoclick\EnumType\RecargoDescuento::valueIsValid()
     * @uses \Sura\Services\Autoclick\EnumType\RecargoDescuento::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recargoDescuento
     * @return \Sura\Services\Autoclick\StructType\DatosBase
     */
    public function setRecargoDescuento($recargoDescuento = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Services\Autoclick\EnumType\RecargoDescuento::valueIsValid($recargoDescuento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sura\Services\Autoclick\EnumType\RecargoDescuento', is_array($recargoDescuento) ? implode(', ', $recargoDescuento) : var_export($recargoDescuento, true), implode(', ', \Sura\Services\Autoclick\EnumType\RecargoDescuento::getValidValues())), __LINE__);
        }
        $this->recargoDescuento = $recargoDescuento;
        return $this;
    }
    /**
     * Get valorRecargo value
     * @return string|null
     */
    public function getValorRecargo()
    {
        return $this->valorRecargo;
    }
    /**
     * Set valorRecargo value
     * @param string $valorRecargo
     * @return \Sura\Services\Autoclick\StructType\DatosBase
     */
    public function setValorRecargo($valorRecargo = null)
    {
        // validation for constraint: string
        if (!is_null($valorRecargo) && !is_string($valorRecargo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valorRecargo, true), gettype($valorRecargo)), __LINE__);
        }
        $this->valorRecargo = $valorRecargo;
        return $this;
    }
}
