<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://training.costaclick.net/WAWS_1_9/Availability.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://training.costaclick.net/WAWS_1_9/Availability.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
$list->setSoapHeaderAgency(new \StructType\Agency());
$list->setSoapHeaderPartner(new \StructType\Partner());
/**
 * Sample call for ListAvailableCruises operation/method
 */
if ($list->ListAvailableCruises(new \StructType\ListAvailableCruises()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAutomaticDiscounts operation/method
 */
if ($list->ListAutomaticDiscounts(new \StructType\ListAutomaticDiscounts()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAllDestinations operation/method
 */
if ($list->ListAllDestinations(new \StructType\ListAllDestinations()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAllShips operation/method
 */
if ($list->ListAllShips(new \StructType\ListAllShips()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAllPorts operation/method
 */
if ($list->ListAllPorts(new \StructType\ListAllPorts()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListShips operation/method
 */
if ($list->ListShips(new \StructType\ListShips()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListPorts operation/method
 */
if ($list->ListPorts(new \StructType\ListPorts()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListFares operation/method
 */
if ($list->ListFares(new \StructType\ListFares()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAvailableCabins operation/method
 */
if ($list->ListAvailableCabins(new \StructType\ListAvailableCabins()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAvailableCabinsWithGroupBooking operation/method
 */
if ($list->ListAvailableCabinsWithGroupBooking(new \StructType\ListAvailableCabinsWithGroupBooking()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAvailableCategories operation/method
 */
if ($list->ListAvailableCategories(new \StructType\ListAvailableCategories()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAvailableCategoriesWithGroupBooking operation/method
 */
if ($list->ListAvailableCategoriesWithGroupBooking(new \StructType\ListAvailableCategoriesWithGroupBooking()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAvailableSpecialServices operation/method
 */
if ($list->ListAvailableSpecialServices(new \StructType\ListAvailableSpecialServices()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListDocuments operation/method
 */
if ($list->ListDocuments(new \StructType\ListDocuments()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAgency(new \StructType\Agency());
$get->setSoapHeaderPartner(new \StructType\Partner());
/**
 * Sample call for GetCruise operation/method
 */
if ($get->GetCruise(new \StructType\GetCruise()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFlightPromoPriceExists operation/method
 */
if ($get->GetFlightPromoPriceExists(new \StructType\GetFlightPromoPriceExists()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
$is->setSoapHeaderAgency(new \StructType\Agency());
$is->setSoapHeaderPartner(new \StructType\Partner());
/**
 * Sample call for IsCruiseInImmediateConfirmForFare operation/method
 */
if ($is->IsCruiseInImmediateConfirmForFare(new \StructType\IsCruiseInImmediateConfirmForFare()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
