<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingByPriceData StructType
 * @subpackage Structs
 */
class ShoppingByPriceData extends AbstractStructBase
{
    /**
     * The RateAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RateAmount;
    /**
     * The RateOccupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateOccupancy;
    /**
     * The CategoryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryCode;
    /**
     * The CategoryDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryDescription;
    /**
     * The RateCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateCode;
    /**
     * The TransportationCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransportationCity;
    /**
     * Constructor method for ShoppingByPriceData
     * @uses ShoppingByPriceData::setRateAmount()
     * @uses ShoppingByPriceData::setRateOccupancy()
     * @uses ShoppingByPriceData::setCategoryCode()
     * @uses ShoppingByPriceData::setCategoryDescription()
     * @uses ShoppingByPriceData::setRateCode()
     * @uses ShoppingByPriceData::setTransportationCity()
     * @param float $rateAmount
     * @param int $rateOccupancy
     * @param string $categoryCode
     * @param string $categoryDescription
     * @param string $rateCode
     * @param string $transportationCity
     */
    public function __construct($rateAmount = null, $rateOccupancy = null, $categoryCode = null, $categoryDescription = null, $rateCode = null, $transportationCity = null)
    {
        $this
            ->setRateAmount($rateAmount)
            ->setRateOccupancy($rateOccupancy)
            ->setCategoryCode($categoryCode)
            ->setCategoryDescription($categoryDescription)
            ->setRateCode($rateCode)
            ->setTransportationCity($transportationCity);
    }
    /**
     * Get RateAmount value
     * @return float
     */
    public function getRateAmount()
    {
        return $this->RateAmount;
    }
    /**
     * Set RateAmount value
     * @param float $rateAmount
     * @return \StructType\ShoppingByPriceData
     */
    public function setRateAmount($rateAmount = null)
    {
        $this->RateAmount = $rateAmount;
        return $this;
    }
    /**
     * Get RateOccupancy value
     * @return int
     */
    public function getRateOccupancy()
    {
        return $this->RateOccupancy;
    }
    /**
     * Set RateOccupancy value
     * @param int $rateOccupancy
     * @return \StructType\ShoppingByPriceData
     */
    public function setRateOccupancy($rateOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($rateOccupancy) && !is_numeric($rateOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateOccupancy)), __LINE__);
        }
        $this->RateOccupancy = $rateOccupancy;
        return $this;
    }
    /**
     * Get CategoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param string $categoryCode
     * @return \StructType\ShoppingByPriceData
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryCode)), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get CategoryDescription value
     * @return string|null
     */
    public function getCategoryDescription()
    {
        return $this->CategoryDescription;
    }
    /**
     * Set CategoryDescription value
     * @param string $categoryDescription
     * @return \StructType\ShoppingByPriceData
     */
    public function setCategoryDescription($categoryDescription = null)
    {
        // validation for constraint: string
        if (!is_null($categoryDescription) && !is_string($categoryDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryDescription)), __LINE__);
        }
        $this->CategoryDescription = $categoryDescription;
        return $this;
    }
    /**
     * Get RateCode value
     * @return string|null
     */
    public function getRateCode()
    {
        return $this->RateCode;
    }
    /**
     * Set RateCode value
     * @param string $rateCode
     * @return \StructType\ShoppingByPriceData
     */
    public function setRateCode($rateCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateCode) && !is_string($rateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateCode)), __LINE__);
        }
        $this->RateCode = $rateCode;
        return $this;
    }
    /**
     * Get TransportationCity value
     * @return string|null
     */
    public function getTransportationCity()
    {
        return $this->TransportationCity;
    }
    /**
     * Set TransportationCity value
     * @param string $transportationCity
     * @return \StructType\ShoppingByPriceData
     */
    public function setTransportationCity($transportationCity = null)
    {
        // validation for constraint: string
        if (!is_null($transportationCity) && !is_string($transportationCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transportationCity)), __LINE__);
        }
        $this->TransportationCity = $transportationCity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingByPriceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
