<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Segment StructType
 * @subpackage Structs
 */
class Segment extends AbstractStructBase
{
    /**
     * The ArrivalTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalTime;
    /**
     * The DepartureTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepartureTime;
    /**
     * The Port
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\City
     */
    public $Port;
    /**
     * Constructor method for Segment
     * @uses Segment::setArrivalTime()
     * @uses Segment::setDepartureTime()
     * @uses Segment::setPort()
     * @param string $arrivalTime
     * @param string $departureTime
     * @param \StructType\City $port
     */
    public function __construct($arrivalTime = null, $departureTime = null, \StructType\City $port = null)
    {
        $this
            ->setArrivalTime($arrivalTime)
            ->setDepartureTime($departureTime)
            ->setPort($port);
    }
    /**
     * Get ArrivalTime value
     * @return string
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \StructType\Segment
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\Segment
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get Port value
     * @return \StructType\City|null
     */
    public function getPort()
    {
        return $this->Port;
    }
    /**
     * Set Port value
     * @param \StructType\City $port
     * @return \StructType\Segment
     */
    public function setPort(\StructType\City $port = null)
    {
        $this->Port = $port;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Segment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
