<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SSVRates StructType
 * @subpackage Structs
 */
class SSVRates extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The CabinAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CabinAmount;
    /**
     * The GuestAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GuestAmount;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for SSVRates
     * @uses SSVRates::setAmount()
     * @uses SSVRates::setCabinAmount()
     * @uses SSVRates::setGuestAmount()
     * @uses SSVRates::setType()
     * @param float $amount
     * @param float $cabinAmount
     * @param float $guestAmount
     * @param string $type
     */
    public function __construct($amount = null, $cabinAmount = null, $guestAmount = null, $type = null)
    {
        $this
            ->setAmount($amount)
            ->setCabinAmount($cabinAmount)
            ->setGuestAmount($guestAmount)
            ->setType($type);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SSVRates
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CabinAmount value
     * @return float
     */
    public function getCabinAmount()
    {
        return $this->CabinAmount;
    }
    /**
     * Set CabinAmount value
     * @param float $cabinAmount
     * @return \StructType\SSVRates
     */
    public function setCabinAmount($cabinAmount = null)
    {
        $this->CabinAmount = $cabinAmount;
        return $this;
    }
    /**
     * Get GuestAmount value
     * @return float
     */
    public function getGuestAmount()
    {
        return $this->GuestAmount;
    }
    /**
     * Set GuestAmount value
     * @param float $guestAmount
     * @return \StructType\SSVRates
     */
    public function setGuestAmount($guestAmount = null)
    {
        $this->GuestAmount = $guestAmount;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\SSVRates
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SSVRates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
