<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SSVAvailable StructType
 * @subpackage Structs
 */
class SSVAvailable extends AbstractStructBase
{
    /**
     * The IsSSVAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSSVAvailable;
    /**
     * Constructor method for SSVAvailable
     * @uses SSVAvailable::setIsSSVAvailable()
     * @param bool $isSSVAvailable
     */
    public function __construct($isSSVAvailable = null)
    {
        $this
            ->setIsSSVAvailable($isSSVAvailable);
    }
    /**
     * Get IsSSVAvailable value
     * @return bool
     */
    public function getIsSSVAvailable()
    {
        return $this->IsSSVAvailable;
    }
    /**
     * Set IsSSVAvailable value
     * @param bool $isSSVAvailable
     * @return \StructType\SSVAvailable
     */
    public function setIsSSVAvailable($isSSVAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSSVAvailable) && !is_bool($isSSVAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSSVAvailable)), __LINE__);
        }
        $this->IsSSVAvailable = $isSSVAvailable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SSVAvailable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
