<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestaurantInfo StructType
 * @subpackage Structs
 */
class RestaurantInfo extends AbstractStructBase
{
    /**
     * The DefaultRestaurant
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DefaultRestaurant;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The TableSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TableSize;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DiningInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDiningInformation
     */
    public $DiningInformation;
    /**
     * Constructor method for RestaurantInfo
     * @uses RestaurantInfo::setDefaultRestaurant()
     * @uses RestaurantInfo::setCode()
     * @uses RestaurantInfo::setTableSize()
     * @uses RestaurantInfo::setDescription()
     * @uses RestaurantInfo::setDiningInformation()
     * @param bool $defaultRestaurant
     * @param string $code
     * @param string $tableSize
     * @param string $description
     * @param \ArrayType\ArrayOfDiningInformation $diningInformation
     */
    public function __construct($defaultRestaurant = null, $code = null, $tableSize = null, $description = null, \ArrayType\ArrayOfDiningInformation $diningInformation = null)
    {
        $this
            ->setDefaultRestaurant($defaultRestaurant)
            ->setCode($code)
            ->setTableSize($tableSize)
            ->setDescription($description)
            ->setDiningInformation($diningInformation);
    }
    /**
     * Get DefaultRestaurant value
     * @return bool
     */
    public function getDefaultRestaurant()
    {
        return $this->DefaultRestaurant;
    }
    /**
     * Set DefaultRestaurant value
     * @param bool $defaultRestaurant
     * @return \StructType\RestaurantInfo
     */
    public function setDefaultRestaurant($defaultRestaurant = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultRestaurant) && !is_bool($defaultRestaurant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultRestaurant)), __LINE__);
        }
        $this->DefaultRestaurant = $defaultRestaurant;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\RestaurantInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get TableSize value
     * @return string|null
     */
    public function getTableSize()
    {
        return $this->TableSize;
    }
    /**
     * Set TableSize value
     * @param string $tableSize
     * @return \StructType\RestaurantInfo
     */
    public function setTableSize($tableSize = null)
    {
        // validation for constraint: string
        if (!is_null($tableSize) && !is_string($tableSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tableSize)), __LINE__);
        }
        $this->TableSize = $tableSize;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\RestaurantInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DiningInformation value
     * @return \ArrayType\ArrayOfDiningInformation|null
     */
    public function getDiningInformation()
    {
        return $this->DiningInformation;
    }
    /**
     * Set DiningInformation value
     * @param \ArrayType\ArrayOfDiningInformation $diningInformation
     * @return \StructType\RestaurantInfo
     */
    public function setDiningInformation(\ArrayType\ArrayOfDiningInformation $diningInformation = null)
    {
        $this->DiningInformation = $diningInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RestaurantInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
