<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateInformation StructType
 * @subpackage Structs
 */
class RateInformation extends AbstractStructBase
{
    /**
     * The MiscChargeAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MiscChargeAmt;
    /**
     * The PortChargeAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PortChargeAmt;
    /**
     * Constructor method for RateInformation
     * @uses RateInformation::setMiscChargeAmt()
     * @uses RateInformation::setPortChargeAmt()
     * @param float $miscChargeAmt
     * @param float $portChargeAmt
     */
    public function __construct($miscChargeAmt = null, $portChargeAmt = null)
    {
        $this
            ->setMiscChargeAmt($miscChargeAmt)
            ->setPortChargeAmt($portChargeAmt);
    }
    /**
     * Get MiscChargeAmt value
     * @return float
     */
    public function getMiscChargeAmt()
    {
        return $this->MiscChargeAmt;
    }
    /**
     * Set MiscChargeAmt value
     * @param float $miscChargeAmt
     * @return \StructType\RateInformation
     */
    public function setMiscChargeAmt($miscChargeAmt = null)
    {
        $this->MiscChargeAmt = $miscChargeAmt;
        return $this;
    }
    /**
     * Get PortChargeAmt value
     * @return float
     */
    public function getPortChargeAmt()
    {
        return $this->PortChargeAmt;
    }
    /**
     * Set PortChargeAmt value
     * @param float $portChargeAmt
     * @return \StructType\RateInformation
     */
    public function setPortChargeAmt($portChargeAmt = null)
    {
        $this->PortChargeAmt = $portChargeAmt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
