<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublicArea StructType
 * @subpackage Structs
 */
class PublicArea extends AbstractStructBase
{
    /**
     * The Capacity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Capacity;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ShipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipCode;
    /**
     * The DeckCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeckCode;
    /**
     * The ShipLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipLocation;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdditionaInfo
     */
    public $AdditionalInfo;
    /**
     * Constructor method for PublicArea
     * @uses PublicArea::setCapacity()
     * @uses PublicArea::setCode()
     * @uses PublicArea::setDescription()
     * @uses PublicArea::setShipCode()
     * @uses PublicArea::setDeckCode()
     * @uses PublicArea::setShipLocation()
     * @uses PublicArea::setAdditionalInfo()
     * @param int $capacity
     * @param string $code
     * @param string $description
     * @param string $shipCode
     * @param string $deckCode
     * @param string $shipLocation
     * @param \StructType\AdditionaInfo $additionalInfo
     */
    public function __construct($capacity = null, $code = null, $description = null, $shipCode = null, $deckCode = null, $shipLocation = null, \StructType\AdditionaInfo $additionalInfo = null)
    {
        $this
            ->setCapacity($capacity)
            ->setCode($code)
            ->setDescription($description)
            ->setShipCode($shipCode)
            ->setDeckCode($deckCode)
            ->setShipLocation($shipLocation)
            ->setAdditionalInfo($additionalInfo);
    }
    /**
     * Get Capacity value
     * @return int
     */
    public function getCapacity()
    {
        return $this->Capacity;
    }
    /**
     * Set Capacity value
     * @param int $capacity
     * @return \StructType\PublicArea
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !is_numeric($capacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($capacity)), __LINE__);
        }
        $this->Capacity = $capacity;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\PublicArea
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PublicArea
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ShipCode value
     * @return string|null
     */
    public function getShipCode()
    {
        return $this->ShipCode;
    }
    /**
     * Set ShipCode value
     * @param string $shipCode
     * @return \StructType\PublicArea
     */
    public function setShipCode($shipCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipCode) && !is_string($shipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipCode)), __LINE__);
        }
        $this->ShipCode = $shipCode;
        return $this;
    }
    /**
     * Get DeckCode value
     * @return string|null
     */
    public function getDeckCode()
    {
        return $this->DeckCode;
    }
    /**
     * Set DeckCode value
     * @param string $deckCode
     * @return \StructType\PublicArea
     */
    public function setDeckCode($deckCode = null)
    {
        // validation for constraint: string
        if (!is_null($deckCode) && !is_string($deckCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deckCode)), __LINE__);
        }
        $this->DeckCode = $deckCode;
        return $this;
    }
    /**
     * Get ShipLocation value
     * @return string|null
     */
    public function getShipLocation()
    {
        return $this->ShipLocation;
    }
    /**
     * Set ShipLocation value
     * @param string $shipLocation
     * @return \StructType\PublicArea
     */
    public function setShipLocation($shipLocation = null)
    {
        // validation for constraint: string
        if (!is_null($shipLocation) && !is_string($shipLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipLocation)), __LINE__);
        }
        $this->ShipLocation = $shipLocation;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \StructType\AdditionaInfo|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \StructType\AdditionaInfo $additionalInfo
     * @return \StructType\PublicArea
     */
    public function setAdditionalInfo(\StructType\AdditionaInfo $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PublicArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
