<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MCTransportation StructType
 * @subpackage Structs
 */
class MCTransportation extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Direction;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalDate;
    /**
     * The DepartureLocationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepartureLocationType;
    /**
     * The ArrivalLocationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalLocationType;
    /**
     * The PublishDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PublishDate;
    /**
     * The CarrierCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The CarrierName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierName;
    /**
     * The CarrierNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierNumber;
    /**
     * The DepartureCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\City
     */
    public $DepartureCity;
    /**
     * The ArrivalCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\City
     */
    public $ArrivalCity;
    /**
     * The ClassCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClassCode;
    /**
     * The ClassDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClassDescription;
    /**
     * The CheckInInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CheckInInformation
     */
    public $CheckInInformation;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The IsTransportationAssignment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsTransportationAssignment;
    /**
     * The DepartureTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepartureTime;
    /**
     * The ArrivalTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalTime;
    /**
     * The SequenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SequenceNumber;
    /**
     * The Charter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Charter;
    /**
     * The FullCharter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FullCharter;
    /**
     * The FreeBaggages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FreeBaggages;
    /**
     * The RealClassCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RealClassCode;
    /**
     * The Seat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Seat;
    /**
     * The Pnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Pnr;
    /**
     * The SegmentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SegmentStatus;
    /**
     * The FltName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FltName;
    /**
     * The DepTerminal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepTerminal;
    /**
     * The ArrTerminal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArrTerminal;
    /**
     * The NoteTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteTypes;
    /**
     * Constructor method for MCTransportation
     * @uses MCTransportation::setType()
     * @uses MCTransportation::setDirection()
     * @uses MCTransportation::setDepartureDate()
     * @uses MCTransportation::setArrivalDate()
     * @uses MCTransportation::setDepartureLocationType()
     * @uses MCTransportation::setArrivalLocationType()
     * @uses MCTransportation::setPublishDate()
     * @uses MCTransportation::setCarrierCode()
     * @uses MCTransportation::setCarrierName()
     * @uses MCTransportation::setCarrierNumber()
     * @uses MCTransportation::setDepartureCity()
     * @uses MCTransportation::setArrivalCity()
     * @uses MCTransportation::setClassCode()
     * @uses MCTransportation::setClassDescription()
     * @uses MCTransportation::setCheckInInformation()
     * @uses MCTransportation::setStatusCode()
     * @uses MCTransportation::setIsTransportationAssignment()
     * @uses MCTransportation::setDepartureTime()
     * @uses MCTransportation::setArrivalTime()
     * @uses MCTransportation::setSequenceNumber()
     * @uses MCTransportation::setCharter()
     * @uses MCTransportation::setFullCharter()
     * @uses MCTransportation::setFreeBaggages()
     * @uses MCTransportation::setRealClassCode()
     * @uses MCTransportation::setSeat()
     * @uses MCTransportation::setPnr()
     * @uses MCTransportation::setSegmentStatus()
     * @uses MCTransportation::setFltName()
     * @uses MCTransportation::setDepTerminal()
     * @uses MCTransportation::setArrTerminal()
     * @uses MCTransportation::setNoteTypes()
     * @param string $type
     * @param string $direction
     * @param string $departureDate
     * @param string $arrivalDate
     * @param string $departureLocationType
     * @param string $arrivalLocationType
     * @param string $publishDate
     * @param string $carrierCode
     * @param string $carrierName
     * @param string $carrierNumber
     * @param \StructType\City $departureCity
     * @param \StructType\City $arrivalCity
     * @param string $classCode
     * @param string $classDescription
     * @param \StructType\CheckInInformation $checkInInformation
     * @param string $statusCode
     * @param string $isTransportationAssignment
     * @param string $departureTime
     * @param string $arrivalTime
     * @param string $sequenceNumber
     * @param string $charter
     * @param string $fullCharter
     * @param string $freeBaggages
     * @param string $realClassCode
     * @param string $seat
     * @param string $pnr
     * @param string $segmentStatus
     * @param string $fltName
     * @param string $depTerminal
     * @param string $arrTerminal
     * @param string $noteTypes
     */
    public function __construct($type = null, $direction = null, $departureDate = null, $arrivalDate = null, $departureLocationType = null, $arrivalLocationType = null, $publishDate = null, $carrierCode = null, $carrierName = null, $carrierNumber = null, \StructType\City $departureCity = null, \StructType\City $arrivalCity = null, $classCode = null, $classDescription = null, \StructType\CheckInInformation $checkInInformation = null, $statusCode = null, $isTransportationAssignment = null, $departureTime = null, $arrivalTime = null, $sequenceNumber = null, $charter = null, $fullCharter = null, $freeBaggages = null, $realClassCode = null, $seat = null, $pnr = null, $segmentStatus = null, $fltName = null, $depTerminal = null, $arrTerminal = null, $noteTypes = null)
    {
        $this
            ->setType($type)
            ->setDirection($direction)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setDepartureLocationType($departureLocationType)
            ->setArrivalLocationType($arrivalLocationType)
            ->setPublishDate($publishDate)
            ->setCarrierCode($carrierCode)
            ->setCarrierName($carrierName)
            ->setCarrierNumber($carrierNumber)
            ->setDepartureCity($departureCity)
            ->setArrivalCity($arrivalCity)
            ->setClassCode($classCode)
            ->setClassDescription($classDescription)
            ->setCheckInInformation($checkInInformation)
            ->setStatusCode($statusCode)
            ->setIsTransportationAssignment($isTransportationAssignment)
            ->setDepartureTime($departureTime)
            ->setArrivalTime($arrivalTime)
            ->setSequenceNumber($sequenceNumber)
            ->setCharter($charter)
            ->setFullCharter($fullCharter)
            ->setFreeBaggages($freeBaggages)
            ->setRealClassCode($realClassCode)
            ->setSeat($seat)
            ->setPnr($pnr)
            ->setSegmentStatus($segmentStatus)
            ->setFltName($fltName)
            ->setDepTerminal($depTerminal)
            ->setArrTerminal($arrTerminal)
            ->setNoteTypes($noteTypes);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\TransportationType::valueIsValid()
     * @uses \EnumType\TransportationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\MCTransportation
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransportationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\TransportationType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Direction value
     * @return string
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\MCTransportation
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $direction, implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\MCTransportation
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\MCTransportation
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get DepartureLocationType value
     * @return string
     */
    public function getDepartureLocationType()
    {
        return $this->DepartureLocationType;
    }
    /**
     * Set DepartureLocationType value
     * @uses \EnumType\LocationType::valueIsValid()
     * @uses \EnumType\LocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureLocationType
     * @return \StructType\MCTransportation
     */
    public function setDepartureLocationType($departureLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationType::valueIsValid($departureLocationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departureLocationType, implode(', ', \EnumType\LocationType::getValidValues())), __LINE__);
        }
        $this->DepartureLocationType = $departureLocationType;
        return $this;
    }
    /**
     * Get ArrivalLocationType value
     * @return string
     */
    public function getArrivalLocationType()
    {
        return $this->ArrivalLocationType;
    }
    /**
     * Set ArrivalLocationType value
     * @uses \EnumType\LocationType::valueIsValid()
     * @uses \EnumType\LocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalLocationType
     * @return \StructType\MCTransportation
     */
    public function setArrivalLocationType($arrivalLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationType::valueIsValid($arrivalLocationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arrivalLocationType, implode(', ', \EnumType\LocationType::getValidValues())), __LINE__);
        }
        $this->ArrivalLocationType = $arrivalLocationType;
        return $this;
    }
    /**
     * Get PublishDate value
     * @return string
     */
    public function getPublishDate()
    {
        return $this->PublishDate;
    }
    /**
     * Set PublishDate value
     * @param string $publishDate
     * @return \StructType\MCTransportation
     */
    public function setPublishDate($publishDate = null)
    {
        // validation for constraint: string
        if (!is_null($publishDate) && !is_string($publishDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($publishDate)), __LINE__);
        }
        $this->PublishDate = $publishDate;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\MCTransportation
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \StructType\MCTransportation
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get CarrierNumber value
     * @return string|null
     */
    public function getCarrierNumber()
    {
        return $this->CarrierNumber;
    }
    /**
     * Set CarrierNumber value
     * @param string $carrierNumber
     * @return \StructType\MCTransportation
     */
    public function setCarrierNumber($carrierNumber = null)
    {
        // validation for constraint: string
        if (!is_null($carrierNumber) && !is_string($carrierNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierNumber)), __LINE__);
        }
        $this->CarrierNumber = $carrierNumber;
        return $this;
    }
    /**
     * Get DepartureCity value
     * @return \StructType\City|null
     */
    public function getDepartureCity()
    {
        return $this->DepartureCity;
    }
    /**
     * Set DepartureCity value
     * @param \StructType\City $departureCity
     * @return \StructType\MCTransportation
     */
    public function setDepartureCity(\StructType\City $departureCity = null)
    {
        $this->DepartureCity = $departureCity;
        return $this;
    }
    /**
     * Get ArrivalCity value
     * @return \StructType\City|null
     */
    public function getArrivalCity()
    {
        return $this->ArrivalCity;
    }
    /**
     * Set ArrivalCity value
     * @param \StructType\City $arrivalCity
     * @return \StructType\MCTransportation
     */
    public function setArrivalCity(\StructType\City $arrivalCity = null)
    {
        $this->ArrivalCity = $arrivalCity;
        return $this;
    }
    /**
     * Get ClassCode value
     * @return string|null
     */
    public function getClassCode()
    {
        return $this->ClassCode;
    }
    /**
     * Set ClassCode value
     * @param string $classCode
     * @return \StructType\MCTransportation
     */
    public function setClassCode($classCode = null)
    {
        // validation for constraint: string
        if (!is_null($classCode) && !is_string($classCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($classCode)), __LINE__);
        }
        $this->ClassCode = $classCode;
        return $this;
    }
    /**
     * Get ClassDescription value
     * @return string|null
     */
    public function getClassDescription()
    {
        return $this->ClassDescription;
    }
    /**
     * Set ClassDescription value
     * @param string $classDescription
     * @return \StructType\MCTransportation
     */
    public function setClassDescription($classDescription = null)
    {
        // validation for constraint: string
        if (!is_null($classDescription) && !is_string($classDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($classDescription)), __LINE__);
        }
        $this->ClassDescription = $classDescription;
        return $this;
    }
    /**
     * Get CheckInInformation value
     * @return \StructType\CheckInInformation|null
     */
    public function getCheckInInformation()
    {
        return $this->CheckInInformation;
    }
    /**
     * Set CheckInInformation value
     * @param \StructType\CheckInInformation $checkInInformation
     * @return \StructType\MCTransportation
     */
    public function setCheckInInformation(\StructType\CheckInInformation $checkInInformation = null)
    {
        $this->CheckInInformation = $checkInInformation;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\MCTransportation
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get IsTransportationAssignment value
     * @return string|null
     */
    public function getIsTransportationAssignment()
    {
        return $this->IsTransportationAssignment;
    }
    /**
     * Set IsTransportationAssignment value
     * @param string $isTransportationAssignment
     * @return \StructType\MCTransportation
     */
    public function setIsTransportationAssignment($isTransportationAssignment = null)
    {
        // validation for constraint: string
        if (!is_null($isTransportationAssignment) && !is_string($isTransportationAssignment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isTransportationAssignment)), __LINE__);
        }
        $this->IsTransportationAssignment = $isTransportationAssignment;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\MCTransportation
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get ArrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \StructType\MCTransportation
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get SequenceNumber value
     * @return string|null
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param string $sequenceNumber
     * @return \StructType\MCTransportation
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNumber) && !is_string($sequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sequenceNumber)), __LINE__);
        }
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get Charter value
     * @return string|null
     */
    public function getCharter()
    {
        return $this->Charter;
    }
    /**
     * Set Charter value
     * @param string $charter
     * @return \StructType\MCTransportation
     */
    public function setCharter($charter = null)
    {
        // validation for constraint: string
        if (!is_null($charter) && !is_string($charter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charter)), __LINE__);
        }
        $this->Charter = $charter;
        return $this;
    }
    /**
     * Get FullCharter value
     * @return string|null
     */
    public function getFullCharter()
    {
        return $this->FullCharter;
    }
    /**
     * Set FullCharter value
     * @param string $fullCharter
     * @return \StructType\MCTransportation
     */
    public function setFullCharter($fullCharter = null)
    {
        // validation for constraint: string
        if (!is_null($fullCharter) && !is_string($fullCharter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullCharter)), __LINE__);
        }
        $this->FullCharter = $fullCharter;
        return $this;
    }
    /**
     * Get FreeBaggages value
     * @return string|null
     */
    public function getFreeBaggages()
    {
        return $this->FreeBaggages;
    }
    /**
     * Set FreeBaggages value
     * @param string $freeBaggages
     * @return \StructType\MCTransportation
     */
    public function setFreeBaggages($freeBaggages = null)
    {
        // validation for constraint: string
        if (!is_null($freeBaggages) && !is_string($freeBaggages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($freeBaggages)), __LINE__);
        }
        $this->FreeBaggages = $freeBaggages;
        return $this;
    }
    /**
     * Get RealClassCode value
     * @return string|null
     */
    public function getRealClassCode()
    {
        return $this->RealClassCode;
    }
    /**
     * Set RealClassCode value
     * @param string $realClassCode
     * @return \StructType\MCTransportation
     */
    public function setRealClassCode($realClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($realClassCode) && !is_string($realClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($realClassCode)), __LINE__);
        }
        $this->RealClassCode = $realClassCode;
        return $this;
    }
    /**
     * Get Seat value
     * @return string|null
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * Set Seat value
     * @param string $seat
     * @return \StructType\MCTransportation
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seat)), __LINE__);
        }
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Get Pnr value
     * @return string|null
     */
    public function getPnr()
    {
        return $this->Pnr;
    }
    /**
     * Set Pnr value
     * @param string $pnr
     * @return \StructType\MCTransportation
     */
    public function setPnr($pnr = null)
    {
        // validation for constraint: string
        if (!is_null($pnr) && !is_string($pnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pnr)), __LINE__);
        }
        $this->Pnr = $pnr;
        return $this;
    }
    /**
     * Get SegmentStatus value
     * @return string|null
     */
    public function getSegmentStatus()
    {
        return $this->SegmentStatus;
    }
    /**
     * Set SegmentStatus value
     * @param string $segmentStatus
     * @return \StructType\MCTransportation
     */
    public function setSegmentStatus($segmentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($segmentStatus) && !is_string($segmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentStatus)), __LINE__);
        }
        $this->SegmentStatus = $segmentStatus;
        return $this;
    }
    /**
     * Get FltName value
     * @return string|null
     */
    public function getFltName()
    {
        return $this->FltName;
    }
    /**
     * Set FltName value
     * @param string $fltName
     * @return \StructType\MCTransportation
     */
    public function setFltName($fltName = null)
    {
        // validation for constraint: string
        if (!is_null($fltName) && !is_string($fltName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fltName)), __LINE__);
        }
        $this->FltName = $fltName;
        return $this;
    }
    /**
     * Get DepTerminal value
     * @return string|null
     */
    public function getDepTerminal()
    {
        return $this->DepTerminal;
    }
    /**
     * Set DepTerminal value
     * @param string $depTerminal
     * @return \StructType\MCTransportation
     */
    public function setDepTerminal($depTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($depTerminal) && !is_string($depTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depTerminal)), __LINE__);
        }
        $this->DepTerminal = $depTerminal;
        return $this;
    }
    /**
     * Get ArrTerminal value
     * @return string|null
     */
    public function getArrTerminal()
    {
        return $this->ArrTerminal;
    }
    /**
     * Set ArrTerminal value
     * @param string $arrTerminal
     * @return \StructType\MCTransportation
     */
    public function setArrTerminal($arrTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($arrTerminal) && !is_string($arrTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrTerminal)), __LINE__);
        }
        $this->ArrTerminal = $arrTerminal;
        return $this;
    }
    /**
     * Get NoteTypes value
     * @return string|null
     */
    public function getNoteTypes()
    {
        return $this->NoteTypes;
    }
    /**
     * Set NoteTypes value
     * @param string $noteTypes
     * @return \StructType\MCTransportation
     */
    public function setNoteTypes($noteTypes = null)
    {
        // validation for constraint: string
        if (!is_null($noteTypes) && !is_string($noteTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteTypes)), __LINE__);
        }
        $this->NoteTypes = $noteTypes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MCTransportation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
