<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestPrice StructType
 * @subpackage Structs
 */
class GuestPrice extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Code;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The PortChgAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PortChgAmount;
    /**
     * The AirFuelSupAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AirFuelSupAmount;
    /**
     * The CruiseFuelSupAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CruiseFuelSupAmount;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The FlightPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlightPrice;
    /**
     * The Discounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDiscount
     */
    public $Discounts;
    /**
     * Constructor method for GuestPrice
     * @uses GuestPrice::setCode()
     * @uses GuestPrice::setAmount()
     * @uses GuestPrice::setPortChgAmount()
     * @uses GuestPrice::setAirFuelSupAmount()
     * @uses GuestPrice::setCruiseFuelSupAmount()
     * @uses GuestPrice::setDescription()
     * @uses GuestPrice::setFlightPrice()
     * @uses GuestPrice::setDiscounts()
     * @param string $code
     * @param float $amount
     * @param float $portChgAmount
     * @param float $airFuelSupAmount
     * @param float $cruiseFuelSupAmount
     * @param string $description
     * @param string $flightPrice
     * @param \ArrayType\ArrayOfDiscount $discounts
     */
    public function __construct($code = null, $amount = null, $portChgAmount = null, $airFuelSupAmount = null, $cruiseFuelSupAmount = null, $description = null, $flightPrice = null, \ArrayType\ArrayOfDiscount $discounts = null)
    {
        $this
            ->setCode($code)
            ->setAmount($amount)
            ->setPortChgAmount($portChgAmount)
            ->setAirFuelSupAmount($airFuelSupAmount)
            ->setCruiseFuelSupAmount($cruiseFuelSupAmount)
            ->setDescription($description)
            ->setFlightPrice($flightPrice)
            ->setDiscounts($discounts);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @uses \EnumType\CategoryTypePrices::valueIsValid()
     * @uses \EnumType\CategoryTypePrices::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\GuestPrice
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CategoryTypePrices::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \EnumType\CategoryTypePrices::getValidValues())), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\GuestPrice
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PortChgAmount value
     * @return float
     */
    public function getPortChgAmount()
    {
        return $this->PortChgAmount;
    }
    /**
     * Set PortChgAmount value
     * @param float $portChgAmount
     * @return \StructType\GuestPrice
     */
    public function setPortChgAmount($portChgAmount = null)
    {
        $this->PortChgAmount = $portChgAmount;
        return $this;
    }
    /**
     * Get AirFuelSupAmount value
     * @return float
     */
    public function getAirFuelSupAmount()
    {
        return $this->AirFuelSupAmount;
    }
    /**
     * Set AirFuelSupAmount value
     * @param float $airFuelSupAmount
     * @return \StructType\GuestPrice
     */
    public function setAirFuelSupAmount($airFuelSupAmount = null)
    {
        $this->AirFuelSupAmount = $airFuelSupAmount;
        return $this;
    }
    /**
     * Get CruiseFuelSupAmount value
     * @return float
     */
    public function getCruiseFuelSupAmount()
    {
        return $this->CruiseFuelSupAmount;
    }
    /**
     * Set CruiseFuelSupAmount value
     * @param float $cruiseFuelSupAmount
     * @return \StructType\GuestPrice
     */
    public function setCruiseFuelSupAmount($cruiseFuelSupAmount = null)
    {
        $this->CruiseFuelSupAmount = $cruiseFuelSupAmount;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\GuestPrice
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FlightPrice value
     * @return string|null
     */
    public function getFlightPrice()
    {
        return $this->FlightPrice;
    }
    /**
     * Set FlightPrice value
     * @param string $flightPrice
     * @return \StructType\GuestPrice
     */
    public function setFlightPrice($flightPrice = null)
    {
        // validation for constraint: string
        if (!is_null($flightPrice) && !is_string($flightPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightPrice)), __LINE__);
        }
        $this->FlightPrice = $flightPrice;
        return $this;
    }
    /**
     * Get Discounts value
     * @return \ArrayType\ArrayOfDiscount|null
     */
    public function getDiscounts()
    {
        return $this->Discounts;
    }
    /**
     * Set Discounts value
     * @param \ArrayType\ArrayOfDiscount $discounts
     * @return \StructType\GuestPrice
     */
    public function setDiscounts(\ArrayType\ArrayOfDiscount $discounts = null)
    {
        $this->Discounts = $discounts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
