<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Component StructType
 * @subpackage Structs
 */
class Component extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Insurance;
    /**
     * The InsuranceAvailableInd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $InsuranceAvailableInd;
    /**
     * The Mandatory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Mandatory;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Direction;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Cities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCity
     */
    public $Cities;
    /**
     * The Fare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Fare
     */
    public $Fare;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Category
     */
    public $Category;
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Cabin
     */
    public $Cabin;
    /**
     * The Hotels
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHotel
     */
    public $Hotels;
    /**
     * The TransportationDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTransportationDetail
     */
    public $TransportationDetails;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdditionaInfo
     */
    public $AdditionalInfo;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The ItemId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemId;
    /**
     * The InsuranceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InsuranceType;
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber;
    /**
     * Constructor method for Component
     * @uses Component::setType()
     * @uses Component::setInsurance()
     * @uses Component::setInsuranceAvailableInd()
     * @uses Component::setMandatory()
     * @uses Component::setDirection()
     * @uses Component::setCode()
     * @uses Component::setCities()
     * @uses Component::setFare()
     * @uses Component::setCategory()
     * @uses Component::setCabin()
     * @uses Component::setHotels()
     * @uses Component::setTransportationDetails()
     * @uses Component::setAdditionalInfo()
     * @uses Component::setStatusCode()
     * @uses Component::setItemId()
     * @uses Component::setInsuranceType()
     * @uses Component::setReferenceNumber()
     * @param string $type
     * @param bool $insurance
     * @param bool $insuranceAvailableInd
     * @param bool $mandatory
     * @param string $direction
     * @param string $code
     * @param \ArrayType\ArrayOfCity $cities
     * @param \StructType\Fare $fare
     * @param \StructType\Category $category
     * @param \StructType\Cabin $cabin
     * @param \ArrayType\ArrayOfHotel $hotels
     * @param \ArrayType\ArrayOfTransportationDetail $transportationDetails
     * @param \StructType\AdditionaInfo $additionalInfo
     * @param string $statusCode
     * @param string $itemId
     * @param string $insuranceType
     * @param string $referenceNumber
     */
    public function __construct($type = null, $insurance = null, $insuranceAvailableInd = null, $mandatory = null, $direction = null, $code = null, \ArrayType\ArrayOfCity $cities = null, \StructType\Fare $fare = null, \StructType\Category $category = null, \StructType\Cabin $cabin = null, \ArrayType\ArrayOfHotel $hotels = null, \ArrayType\ArrayOfTransportationDetail $transportationDetails = null, \StructType\AdditionaInfo $additionalInfo = null, $statusCode = null, $itemId = null, $insuranceType = null, $referenceNumber = null)
    {
        $this
            ->setType($type)
            ->setInsurance($insurance)
            ->setInsuranceAvailableInd($insuranceAvailableInd)
            ->setMandatory($mandatory)
            ->setDirection($direction)
            ->setCode($code)
            ->setCities($cities)
            ->setFare($fare)
            ->setCategory($category)
            ->setCabin($cabin)
            ->setHotels($hotels)
            ->setTransportationDetails($transportationDetails)
            ->setAdditionalInfo($additionalInfo)
            ->setStatusCode($statusCode)
            ->setItemId($itemId)
            ->setInsuranceType($insuranceType)
            ->setReferenceNumber($referenceNumber);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ComponentType::valueIsValid()
     * @uses \EnumType\ComponentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Component
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComponentType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ComponentType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Insurance value
     * @return bool
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param bool $insurance
     * @return \StructType\Component
     */
    public function setInsurance($insurance = null)
    {
        // validation for constraint: boolean
        if (!is_null($insurance) && !is_bool($insurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($insurance)), __LINE__);
        }
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get InsuranceAvailableInd value
     * @return bool
     */
    public function getInsuranceAvailableInd()
    {
        return $this->InsuranceAvailableInd;
    }
    /**
     * Set InsuranceAvailableInd value
     * @param bool $insuranceAvailableInd
     * @return \StructType\Component
     */
    public function setInsuranceAvailableInd($insuranceAvailableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($insuranceAvailableInd) && !is_bool($insuranceAvailableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($insuranceAvailableInd)), __LINE__);
        }
        $this->InsuranceAvailableInd = $insuranceAvailableInd;
        return $this;
    }
    /**
     * Get Mandatory value
     * @return bool
     */
    public function getMandatory()
    {
        return $this->Mandatory;
    }
    /**
     * Set Mandatory value
     * @param bool $mandatory
     * @return \StructType\Component
     */
    public function setMandatory($mandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mandatory)), __LINE__);
        }
        $this->Mandatory = $mandatory;
        return $this;
    }
    /**
     * Get Direction value
     * @return string
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\Component
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $direction, implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Component
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Cities value
     * @return \ArrayType\ArrayOfCity|null
     */
    public function getCities()
    {
        return $this->Cities;
    }
    /**
     * Set Cities value
     * @param \ArrayType\ArrayOfCity $cities
     * @return \StructType\Component
     */
    public function setCities(\ArrayType\ArrayOfCity $cities = null)
    {
        $this->Cities = $cities;
        return $this;
    }
    /**
     * Get Fare value
     * @return \StructType\Fare|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \StructType\Fare $fare
     * @return \StructType\Component
     */
    public function setFare(\StructType\Fare $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get Category value
     * @return \StructType\Category|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \StructType\Category $category
     * @return \StructType\Component
     */
    public function setCategory(\StructType\Category $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Cabin value
     * @return \StructType\Cabin|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param \StructType\Cabin $cabin
     * @return \StructType\Component
     */
    public function setCabin(\StructType\Cabin $cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get Hotels value
     * @return \ArrayType\ArrayOfHotel|null
     */
    public function getHotels()
    {
        return $this->Hotels;
    }
    /**
     * Set Hotels value
     * @param \ArrayType\ArrayOfHotel $hotels
     * @return \StructType\Component
     */
    public function setHotels(\ArrayType\ArrayOfHotel $hotels = null)
    {
        $this->Hotels = $hotels;
        return $this;
    }
    /**
     * Get TransportationDetails value
     * @return \ArrayType\ArrayOfTransportationDetail|null
     */
    public function getTransportationDetails()
    {
        return $this->TransportationDetails;
    }
    /**
     * Set TransportationDetails value
     * @param \ArrayType\ArrayOfTransportationDetail $transportationDetails
     * @return \StructType\Component
     */
    public function setTransportationDetails(\ArrayType\ArrayOfTransportationDetail $transportationDetails = null)
    {
        $this->TransportationDetails = $transportationDetails;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \StructType\AdditionaInfo|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \StructType\AdditionaInfo $additionalInfo
     * @return \StructType\Component
     */
    public function setAdditionalInfo(\StructType\AdditionaInfo $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\Component
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ItemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param string $itemId
     * @return \StructType\Component
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get InsuranceType value
     * @return string|null
     */
    public function getInsuranceType()
    {
        return $this->InsuranceType;
    }
    /**
     * Set InsuranceType value
     * @param string $insuranceType
     * @return \StructType\Component
     */
    public function setInsuranceType($insuranceType = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceType) && !is_string($insuranceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insuranceType)), __LINE__);
        }
        $this->InsuranceType = $insuranceType;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\Component
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Component
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
