<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Compensation StructType
 * @subpackage Structs
 */
class Compensation extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BirthDate;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The VoucherId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherId;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The TypeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeDescription;
    /**
     * The ItemType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemType;
    /**
     * The DiscountCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscountCode;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The BookingType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingType;
    /**
     * The CombinabilityCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CombinabilityCode;
    /**
     * The ApplicationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationType;
    /**
     * The IsMaster
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsMaster;
    /**
     * The CompensationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompensationCode;
    /**
     * The CompensationPercentage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompensationPercentage;
    /**
     * The DiscoutType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscoutType;
    /**
     * The DiscountId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscountId;
    /**
     * The DiscountValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscountValue;
    /**
     * The GuestSequenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GuestSequenceNumber;
    /**
     * Constructor method for Compensation
     * @uses Compensation::setAmount()
     * @uses Compensation::setBirthDate()
     * @uses Compensation::setType()
     * @uses Compensation::setDescription()
     * @uses Compensation::setVoucherId()
     * @uses Compensation::setCurrency()
     * @uses Compensation::setTypeDescription()
     * @uses Compensation::setItemType()
     * @uses Compensation::setDiscountCode()
     * @uses Compensation::setFirstName()
     * @uses Compensation::setLastName()
     * @uses Compensation::setBookingType()
     * @uses Compensation::setCombinabilityCode()
     * @uses Compensation::setApplicationType()
     * @uses Compensation::setIsMaster()
     * @uses Compensation::setCompensationCode()
     * @uses Compensation::setCompensationPercentage()
     * @uses Compensation::setDiscoutType()
     * @uses Compensation::setDiscountId()
     * @uses Compensation::setDiscountValue()
     * @uses Compensation::setGuestSequenceNumber()
     * @param float $amount
     * @param string $birthDate
     * @param string $type
     * @param string $description
     * @param string $voucherId
     * @param string $currency
     * @param string $typeDescription
     * @param string $itemType
     * @param string $discountCode
     * @param string $firstName
     * @param string $lastName
     * @param string $bookingType
     * @param string $combinabilityCode
     * @param string $applicationType
     * @param string $isMaster
     * @param string $compensationCode
     * @param string $compensationPercentage
     * @param string $discoutType
     * @param string $discountId
     * @param string $discountValue
     * @param string $guestSequenceNumber
     */
    public function __construct($amount = null, $birthDate = null, $type = null, $description = null, $voucherId = null, $currency = null, $typeDescription = null, $itemType = null, $discountCode = null, $firstName = null, $lastName = null, $bookingType = null, $combinabilityCode = null, $applicationType = null, $isMaster = null, $compensationCode = null, $compensationPercentage = null, $discoutType = null, $discountId = null, $discountValue = null, $guestSequenceNumber = null)
    {
        $this
            ->setAmount($amount)
            ->setBirthDate($birthDate)
            ->setType($type)
            ->setDescription($description)
            ->setVoucherId($voucherId)
            ->setCurrency($currency)
            ->setTypeDescription($typeDescription)
            ->setItemType($itemType)
            ->setDiscountCode($discountCode)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setBookingType($bookingType)
            ->setCombinabilityCode($combinabilityCode)
            ->setApplicationType($applicationType)
            ->setIsMaster($isMaster)
            ->setCompensationCode($compensationCode)
            ->setCompensationPercentage($compensationPercentage)
            ->setDiscoutType($discoutType)
            ->setDiscountId($discountId)
            ->setDiscountValue($discountValue)
            ->setGuestSequenceNumber($guestSequenceNumber);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Compensation
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\Compensation
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Compensation
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Compensation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get VoucherId value
     * @return string|null
     */
    public function getVoucherId()
    {
        return $this->VoucherId;
    }
    /**
     * Set VoucherId value
     * @param string $voucherId
     * @return \StructType\Compensation
     */
    public function setVoucherId($voucherId = null)
    {
        // validation for constraint: string
        if (!is_null($voucherId) && !is_string($voucherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voucherId)), __LINE__);
        }
        $this->VoucherId = $voucherId;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\Compensation
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get TypeDescription value
     * @return string|null
     */
    public function getTypeDescription()
    {
        return $this->TypeDescription;
    }
    /**
     * Set TypeDescription value
     * @param string $typeDescription
     * @return \StructType\Compensation
     */
    public function setTypeDescription($typeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($typeDescription) && !is_string($typeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeDescription)), __LINE__);
        }
        $this->TypeDescription = $typeDescription;
        return $this;
    }
    /**
     * Get ItemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @param string $itemType
     * @return \StructType\Compensation
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: string
        if (!is_null($itemType) && !is_string($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemType)), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\Compensation
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Compensation
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Compensation
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get BookingType value
     * @return string|null
     */
    public function getBookingType()
    {
        return $this->BookingType;
    }
    /**
     * Set BookingType value
     * @param string $bookingType
     * @return \StructType\Compensation
     */
    public function setBookingType($bookingType = null)
    {
        // validation for constraint: string
        if (!is_null($bookingType) && !is_string($bookingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingType)), __LINE__);
        }
        $this->BookingType = $bookingType;
        return $this;
    }
    /**
     * Get CombinabilityCode value
     * @return string|null
     */
    public function getCombinabilityCode()
    {
        return $this->CombinabilityCode;
    }
    /**
     * Set CombinabilityCode value
     * @param string $combinabilityCode
     * @return \StructType\Compensation
     */
    public function setCombinabilityCode($combinabilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($combinabilityCode) && !is_string($combinabilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($combinabilityCode)), __LINE__);
        }
        $this->CombinabilityCode = $combinabilityCode;
        return $this;
    }
    /**
     * Get ApplicationType value
     * @return string|null
     */
    public function getApplicationType()
    {
        return $this->ApplicationType;
    }
    /**
     * Set ApplicationType value
     * @param string $applicationType
     * @return \StructType\Compensation
     */
    public function setApplicationType($applicationType = null)
    {
        // validation for constraint: string
        if (!is_null($applicationType) && !is_string($applicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationType)), __LINE__);
        }
        $this->ApplicationType = $applicationType;
        return $this;
    }
    /**
     * Get IsMaster value
     * @return string|null
     */
    public function getIsMaster()
    {
        return $this->IsMaster;
    }
    /**
     * Set IsMaster value
     * @param string $isMaster
     * @return \StructType\Compensation
     */
    public function setIsMaster($isMaster = null)
    {
        // validation for constraint: string
        if (!is_null($isMaster) && !is_string($isMaster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isMaster)), __LINE__);
        }
        $this->IsMaster = $isMaster;
        return $this;
    }
    /**
     * Get CompensationCode value
     * @return string|null
     */
    public function getCompensationCode()
    {
        return $this->CompensationCode;
    }
    /**
     * Set CompensationCode value
     * @param string $compensationCode
     * @return \StructType\Compensation
     */
    public function setCompensationCode($compensationCode = null)
    {
        // validation for constraint: string
        if (!is_null($compensationCode) && !is_string($compensationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($compensationCode)), __LINE__);
        }
        $this->CompensationCode = $compensationCode;
        return $this;
    }
    /**
     * Get CompensationPercentage value
     * @return string|null
     */
    public function getCompensationPercentage()
    {
        return $this->CompensationPercentage;
    }
    /**
     * Set CompensationPercentage value
     * @param string $compensationPercentage
     * @return \StructType\Compensation
     */
    public function setCompensationPercentage($compensationPercentage = null)
    {
        // validation for constraint: string
        if (!is_null($compensationPercentage) && !is_string($compensationPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($compensationPercentage)), __LINE__);
        }
        $this->CompensationPercentage = $compensationPercentage;
        return $this;
    }
    /**
     * Get DiscoutType value
     * @return string|null
     */
    public function getDiscoutType()
    {
        return $this->DiscoutType;
    }
    /**
     * Set DiscoutType value
     * @param string $discoutType
     * @return \StructType\Compensation
     */
    public function setDiscoutType($discoutType = null)
    {
        // validation for constraint: string
        if (!is_null($discoutType) && !is_string($discoutType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discoutType)), __LINE__);
        }
        $this->DiscoutType = $discoutType;
        return $this;
    }
    /**
     * Get DiscountId value
     * @return string|null
     */
    public function getDiscountId()
    {
        return $this->DiscountId;
    }
    /**
     * Set DiscountId value
     * @param string $discountId
     * @return \StructType\Compensation
     */
    public function setDiscountId($discountId = null)
    {
        // validation for constraint: string
        if (!is_null($discountId) && !is_string($discountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountId)), __LINE__);
        }
        $this->DiscountId = $discountId;
        return $this;
    }
    /**
     * Get DiscountValue value
     * @return string|null
     */
    public function getDiscountValue()
    {
        return $this->DiscountValue;
    }
    /**
     * Set DiscountValue value
     * @param string $discountValue
     * @return \StructType\Compensation
     */
    public function setDiscountValue($discountValue = null)
    {
        // validation for constraint: string
        if (!is_null($discountValue) && !is_string($discountValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountValue)), __LINE__);
        }
        $this->DiscountValue = $discountValue;
        return $this;
    }
    /**
     * Get GuestSequenceNumber value
     * @return string|null
     */
    public function getGuestSequenceNumber()
    {
        return $this->GuestSequenceNumber;
    }
    /**
     * Set GuestSequenceNumber value
     * @param string $guestSequenceNumber
     * @return \StructType\Compensation
     */
    public function setGuestSequenceNumber($guestSequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($guestSequenceNumber) && !is_string($guestSequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guestSequenceNumber)), __LINE__);
        }
        $this->GuestSequenceNumber = $guestSequenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Compensation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
