<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckInInformation StructType
 * @subpackage Structs
 */
class CheckInInformation extends AbstractStructBase
{
    /**
     * The CheckInDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CheckInDate;
    /**
     * The TerminalNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TerminalNumber;
    /**
     * Constructor method for CheckInInformation
     * @uses CheckInInformation::setCheckInDate()
     * @uses CheckInInformation::setTerminalNumber()
     * @param string $checkInDate
     * @param string $terminalNumber
     */
    public function __construct($checkInDate = null, $terminalNumber = null)
    {
        $this
            ->setCheckInDate($checkInDate)
            ->setTerminalNumber($terminalNumber);
    }
    /**
     * Get CheckInDate value
     * @return string
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }
    /**
     * Set CheckInDate value
     * @param string $checkInDate
     * @return \StructType\CheckInInformation
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkInDate)), __LINE__);
        }
        $this->CheckInDate = $checkInDate;
        return $this;
    }
    /**
     * Get TerminalNumber value
     * @return string|null
     */
    public function getTerminalNumber()
    {
        return $this->TerminalNumber;
    }
    /**
     * Set TerminalNumber value
     * @param string $terminalNumber
     * @return \StructType\CheckInInformation
     */
    public function setTerminalNumber($terminalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($terminalNumber) && !is_string($terminalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminalNumber)), __LINE__);
        }
        $this->TerminalNumber = $terminalNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckInInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
