<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Category StructType
 * @subpackage Structs
 */
class Category extends AbstractStructBase
{
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Availability;
    /**
     * The CabinLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CabinLocation;
    /**
     * The IsSingleCabin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSingleCabin;
    /**
     * The MaxOccupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The MinOccupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinOccupancy;
    /**
     * The Order
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Order;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The ShipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipCode;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuestPrice
     */
    public $Price;
    /**
     * The Ship
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Ship
     */
    public $Ship;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdditionaInfo
     */
    public $AdditionalInfo;
    /**
     * The UpgradeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpgradeCode;
    /**
     * The CabinAvailabilityInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CabinAvailabilityInfo
     */
    public $CabinAvailabilityInformation;
    /**
     * The AdditionalDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalDescription;
    /**
     * The SuperCategoryType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SuperCategoryType;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Scores
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfScore
     */
    public $Scores;
    /**
     * Constructor method for Category
     * @uses Category::setAvailability()
     * @uses Category::setCabinLocation()
     * @uses Category::setIsSingleCabin()
     * @uses Category::setMaxOccupancy()
     * @uses Category::setMinOccupancy()
     * @uses Category::setOrder()
     * @uses Category::setCode()
     * @uses Category::setName()
     * @uses Category::setShipCode()
     * @uses Category::setStatusCode()
     * @uses Category::setPrice()
     * @uses Category::setShip()
     * @uses Category::setURL()
     * @uses Category::setAdditionalInfo()
     * @uses Category::setUpgradeCode()
     * @uses Category::setCabinAvailabilityInformation()
     * @uses Category::setAdditionalDescription()
     * @uses Category::setSuperCategoryType()
     * @uses Category::setCurrencyCode()
     * @uses Category::setScores()
     * @param bool $availability
     * @param string $cabinLocation
     * @param bool $isSingleCabin
     * @param int $maxOccupancy
     * @param int $minOccupancy
     * @param int $order
     * @param string $code
     * @param string $name
     * @param string $shipCode
     * @param string $statusCode
     * @param \ArrayType\ArrayOfGuestPrice $price
     * @param \StructType\Ship $ship
     * @param string $uRL
     * @param \StructType\AdditionaInfo $additionalInfo
     * @param string $upgradeCode
     * @param \StructType\CabinAvailabilityInfo $cabinAvailabilityInformation
     * @param string $additionalDescription
     * @param string $superCategoryType
     * @param string $currencyCode
     * @param \ArrayType\ArrayOfScore $scores
     */
    public function __construct($availability = null, $cabinLocation = null, $isSingleCabin = null, $maxOccupancy = null, $minOccupancy = null, $order = null, $code = null, $name = null, $shipCode = null, $statusCode = null, \ArrayType\ArrayOfGuestPrice $price = null, \StructType\Ship $ship = null, $uRL = null, \StructType\AdditionaInfo $additionalInfo = null, $upgradeCode = null, \StructType\CabinAvailabilityInfo $cabinAvailabilityInformation = null, $additionalDescription = null, $superCategoryType = null, $currencyCode = null, \ArrayType\ArrayOfScore $scores = null)
    {
        $this
            ->setAvailability($availability)
            ->setCabinLocation($cabinLocation)
            ->setIsSingleCabin($isSingleCabin)
            ->setMaxOccupancy($maxOccupancy)
            ->setMinOccupancy($minOccupancy)
            ->setOrder($order)
            ->setCode($code)
            ->setName($name)
            ->setShipCode($shipCode)
            ->setStatusCode($statusCode)
            ->setPrice($price)
            ->setShip($ship)
            ->setURL($uRL)
            ->setAdditionalInfo($additionalInfo)
            ->setUpgradeCode($upgradeCode)
            ->setCabinAvailabilityInformation($cabinAvailabilityInformation)
            ->setAdditionalDescription($additionalDescription)
            ->setSuperCategoryType($superCategoryType)
            ->setCurrencyCode($currencyCode)
            ->setScores($scores);
    }
    /**
     * Get Availability value
     * @return bool
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param bool $availability
     * @return \StructType\Category
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: boolean
        if (!is_null($availability) && !is_bool($availability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availability)), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get CabinLocation value
     * @return string
     */
    public function getCabinLocation()
    {
        return $this->CabinLocation;
    }
    /**
     * Set CabinLocation value
     * @uses \EnumType\CabinLocation::valueIsValid()
     * @uses \EnumType\CabinLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinLocation
     * @return \StructType\Category
     */
    public function setCabinLocation($cabinLocation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinLocation::valueIsValid($cabinLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cabinLocation, implode(', ', \EnumType\CabinLocation::getValidValues())), __LINE__);
        }
        $this->CabinLocation = $cabinLocation;
        return $this;
    }
    /**
     * Get IsSingleCabin value
     * @return bool
     */
    public function getIsSingleCabin()
    {
        return $this->IsSingleCabin;
    }
    /**
     * Set IsSingleCabin value
     * @param bool $isSingleCabin
     * @return \StructType\Category
     */
    public function setIsSingleCabin($isSingleCabin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSingleCabin) && !is_bool($isSingleCabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSingleCabin)), __LINE__);
        }
        $this->IsSingleCabin = $isSingleCabin;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\Category
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !is_numeric($maxOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get MinOccupancy value
     * @return int
     */
    public function getMinOccupancy()
    {
        return $this->MinOccupancy;
    }
    /**
     * Set MinOccupancy value
     * @param int $minOccupancy
     * @return \StructType\Category
     */
    public function setMinOccupancy($minOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minOccupancy) && !is_numeric($minOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minOccupancy)), __LINE__);
        }
        $this->MinOccupancy = $minOccupancy;
        return $this;
    }
    /**
     * Get Order value
     * @return int
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\Category
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Category
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Category
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ShipCode value
     * @return string|null
     */
    public function getShipCode()
    {
        return $this->ShipCode;
    }
    /**
     * Set ShipCode value
     * @param string $shipCode
     * @return \StructType\Category
     */
    public function setShipCode($shipCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipCode) && !is_string($shipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipCode)), __LINE__);
        }
        $this->ShipCode = $shipCode;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\Category
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Price value
     * @return \ArrayType\ArrayOfGuestPrice|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \ArrayType\ArrayOfGuestPrice $price
     * @return \StructType\Category
     */
    public function setPrice(\ArrayType\ArrayOfGuestPrice $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Ship value
     * @return \StructType\Ship|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \StructType\Ship $ship
     * @return \StructType\Category
     */
    public function setShip(\StructType\Ship $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\Category
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \StructType\AdditionaInfo|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \StructType\AdditionaInfo $additionalInfo
     * @return \StructType\Category
     */
    public function setAdditionalInfo(\StructType\AdditionaInfo $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get UpgradeCode value
     * @return string|null
     */
    public function getUpgradeCode()
    {
        return $this->UpgradeCode;
    }
    /**
     * Set UpgradeCode value
     * @param string $upgradeCode
     * @return \StructType\Category
     */
    public function setUpgradeCode($upgradeCode = null)
    {
        // validation for constraint: string
        if (!is_null($upgradeCode) && !is_string($upgradeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($upgradeCode)), __LINE__);
        }
        $this->UpgradeCode = $upgradeCode;
        return $this;
    }
    /**
     * Get CabinAvailabilityInformation value
     * @return \StructType\CabinAvailabilityInfo|null
     */
    public function getCabinAvailabilityInformation()
    {
        return $this->CabinAvailabilityInformation;
    }
    /**
     * Set CabinAvailabilityInformation value
     * @param \StructType\CabinAvailabilityInfo $cabinAvailabilityInformation
     * @return \StructType\Category
     */
    public function setCabinAvailabilityInformation(\StructType\CabinAvailabilityInfo $cabinAvailabilityInformation = null)
    {
        $this->CabinAvailabilityInformation = $cabinAvailabilityInformation;
        return $this;
    }
    /**
     * Get AdditionalDescription value
     * @return string|null
     */
    public function getAdditionalDescription()
    {
        return $this->AdditionalDescription;
    }
    /**
     * Set AdditionalDescription value
     * @param string $additionalDescription
     * @return \StructType\Category
     */
    public function setAdditionalDescription($additionalDescription = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDescription) && !is_string($additionalDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additionalDescription)), __LINE__);
        }
        $this->AdditionalDescription = $additionalDescription;
        return $this;
    }
    /**
     * Get SuperCategoryType value
     * @return string|null
     */
    public function getSuperCategoryType()
    {
        return $this->SuperCategoryType;
    }
    /**
     * Set SuperCategoryType value
     * @param string $superCategoryType
     * @return \StructType\Category
     */
    public function setSuperCategoryType($superCategoryType = null)
    {
        // validation for constraint: string
        if (!is_null($superCategoryType) && !is_string($superCategoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($superCategoryType)), __LINE__);
        }
        $this->SuperCategoryType = $superCategoryType;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\Category
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Scores value
     * @return \ArrayType\ArrayOfScore|null
     */
    public function getScores()
    {
        return $this->Scores;
    }
    /**
     * Set Scores value
     * @param \ArrayType\ArrayOfScore $scores
     * @return \StructType\Category
     */
    public function setScores(\ArrayType\ArrayOfScore $scores = null)
    {
        $this->Scores = $scores;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Category
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
