<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cabin StructType
 * @subpackage Structs
 */
class Cabin extends AbstractStructBase
{
    /**
     * The MinOccupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinOccupancy;
    /**
     * The MaxOccupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The Facility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Facility;
    /**
     * The DiningPreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DiningPreference;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Category
     */
    public $Category;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The DeckName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeckName;
    /**
     * The DeckCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeckCode;
    /**
     * The Beds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBed
     */
    public $Beds;
    /**
     * The Cruise
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Cruise
     */
    public $Cruise;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The RateInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RateInformation
     */
    public $RateInformation;
    /**
     * The DiningWithInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDiningWith
     */
    public $DiningWithInformation;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdditionaInfo
     */
    public $AdditionalInfo;
    /**
     * The GuestsCabinInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuestCabinInfo
     */
    public $GuestsCabinInfo;
    /**
     * The RestaurantInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RestaurantInfo
     */
    public $RestaurantInfo;
    /**
     * The DiningSatisfaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiningSatisfaction;
    /**
     * The ServiceLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceLevel;
    /**
     * Constructor method for Cabin
     * @uses Cabin::setMinOccupancy()
     * @uses Cabin::setMaxOccupancy()
     * @uses Cabin::setFacility()
     * @uses Cabin::setDiningPreference()
     * @uses Cabin::setNumber()
     * @uses Cabin::setCategory()
     * @uses Cabin::setStatus()
     * @uses Cabin::setDeckName()
     * @uses Cabin::setDeckCode()
     * @uses Cabin::setBeds()
     * @uses Cabin::setCruise()
     * @uses Cabin::setURL()
     * @uses Cabin::setRateInformation()
     * @uses Cabin::setDiningWithInformation()
     * @uses Cabin::setAdditionalInfo()
     * @uses Cabin::setGuestsCabinInfo()
     * @uses Cabin::setRestaurantInfo()
     * @uses Cabin::setDiningSatisfaction()
     * @uses Cabin::setServiceLevel()
     * @param int $minOccupancy
     * @param int $maxOccupancy
     * @param bool $facility
     * @param string $diningPreference
     * @param string $number
     * @param \StructType\Category $category
     * @param string $status
     * @param string $deckName
     * @param string $deckCode
     * @param \ArrayType\ArrayOfBed $beds
     * @param \StructType\Cruise $cruise
     * @param string $uRL
     * @param \StructType\RateInformation $rateInformation
     * @param \ArrayType\ArrayOfDiningWith $diningWithInformation
     * @param \StructType\AdditionaInfo $additionalInfo
     * @param \ArrayType\ArrayOfGuestCabinInfo $guestsCabinInfo
     * @param \StructType\RestaurantInfo $restaurantInfo
     * @param string $diningSatisfaction
     * @param string $serviceLevel
     */
    public function __construct($minOccupancy = null, $maxOccupancy = null, $facility = null, $diningPreference = null, $number = null, \StructType\Category $category = null, $status = null, $deckName = null, $deckCode = null, \ArrayType\ArrayOfBed $beds = null, \StructType\Cruise $cruise = null, $uRL = null, \StructType\RateInformation $rateInformation = null, \ArrayType\ArrayOfDiningWith $diningWithInformation = null, \StructType\AdditionaInfo $additionalInfo = null, \ArrayType\ArrayOfGuestCabinInfo $guestsCabinInfo = null, \StructType\RestaurantInfo $restaurantInfo = null, $diningSatisfaction = null, $serviceLevel = null)
    {
        $this
            ->setMinOccupancy($minOccupancy)
            ->setMaxOccupancy($maxOccupancy)
            ->setFacility($facility)
            ->setDiningPreference($diningPreference)
            ->setNumber($number)
            ->setCategory($category)
            ->setStatus($status)
            ->setDeckName($deckName)
            ->setDeckCode($deckCode)
            ->setBeds($beds)
            ->setCruise($cruise)
            ->setURL($uRL)
            ->setRateInformation($rateInformation)
            ->setDiningWithInformation($diningWithInformation)
            ->setAdditionalInfo($additionalInfo)
            ->setGuestsCabinInfo($guestsCabinInfo)
            ->setRestaurantInfo($restaurantInfo)
            ->setDiningSatisfaction($diningSatisfaction)
            ->setServiceLevel($serviceLevel);
    }
    /**
     * Get MinOccupancy value
     * @return int
     */
    public function getMinOccupancy()
    {
        return $this->MinOccupancy;
    }
    /**
     * Set MinOccupancy value
     * @param int $minOccupancy
     * @return \StructType\Cabin
     */
    public function setMinOccupancy($minOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minOccupancy) && !is_numeric($minOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minOccupancy)), __LINE__);
        }
        $this->MinOccupancy = $minOccupancy;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\Cabin
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !is_numeric($maxOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get Facility value
     * @return bool
     */
    public function getFacility()
    {
        return $this->Facility;
    }
    /**
     * Set Facility value
     * @param bool $facility
     * @return \StructType\Cabin
     */
    public function setFacility($facility = null)
    {
        // validation for constraint: boolean
        if (!is_null($facility) && !is_bool($facility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($facility)), __LINE__);
        }
        $this->Facility = $facility;
        return $this;
    }
    /**
     * Get DiningPreference value
     * @return string
     */
    public function getDiningPreference()
    {
        return $this->DiningPreference;
    }
    /**
     * Set DiningPreference value
     * @uses \EnumType\Dining::valueIsValid()
     * @uses \EnumType\Dining::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $diningPreference
     * @return \StructType\Cabin
     */
    public function setDiningPreference($diningPreference = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Dining::valueIsValid($diningPreference)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $diningPreference, implode(', ', \EnumType\Dining::getValidValues())), __LINE__);
        }
        $this->DiningPreference = $diningPreference;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\Cabin
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Category value
     * @return \StructType\Category|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \StructType\Category $category
     * @return \StructType\Cabin
     */
    public function setCategory(\StructType\Category $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Cabin
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DeckName value
     * @return string|null
     */
    public function getDeckName()
    {
        return $this->DeckName;
    }
    /**
     * Set DeckName value
     * @param string $deckName
     * @return \StructType\Cabin
     */
    public function setDeckName($deckName = null)
    {
        // validation for constraint: string
        if (!is_null($deckName) && !is_string($deckName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deckName)), __LINE__);
        }
        $this->DeckName = $deckName;
        return $this;
    }
    /**
     * Get DeckCode value
     * @return string|null
     */
    public function getDeckCode()
    {
        return $this->DeckCode;
    }
    /**
     * Set DeckCode value
     * @param string $deckCode
     * @return \StructType\Cabin
     */
    public function setDeckCode($deckCode = null)
    {
        // validation for constraint: string
        if (!is_null($deckCode) && !is_string($deckCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deckCode)), __LINE__);
        }
        $this->DeckCode = $deckCode;
        return $this;
    }
    /**
     * Get Beds value
     * @return \ArrayType\ArrayOfBed|null
     */
    public function getBeds()
    {
        return $this->Beds;
    }
    /**
     * Set Beds value
     * @param \ArrayType\ArrayOfBed $beds
     * @return \StructType\Cabin
     */
    public function setBeds(\ArrayType\ArrayOfBed $beds = null)
    {
        $this->Beds = $beds;
        return $this;
    }
    /**
     * Get Cruise value
     * @return \StructType\Cruise|null
     */
    public function getCruise()
    {
        return $this->Cruise;
    }
    /**
     * Set Cruise value
     * @param \StructType\Cruise $cruise
     * @return \StructType\Cabin
     */
    public function setCruise(\StructType\Cruise $cruise = null)
    {
        $this->Cruise = $cruise;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\Cabin
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get RateInformation value
     * @return \StructType\RateInformation|null
     */
    public function getRateInformation()
    {
        return $this->RateInformation;
    }
    /**
     * Set RateInformation value
     * @param \StructType\RateInformation $rateInformation
     * @return \StructType\Cabin
     */
    public function setRateInformation(\StructType\RateInformation $rateInformation = null)
    {
        $this->RateInformation = $rateInformation;
        return $this;
    }
    /**
     * Get DiningWithInformation value
     * @return \ArrayType\ArrayOfDiningWith|null
     */
    public function getDiningWithInformation()
    {
        return $this->DiningWithInformation;
    }
    /**
     * Set DiningWithInformation value
     * @param \ArrayType\ArrayOfDiningWith $diningWithInformation
     * @return \StructType\Cabin
     */
    public function setDiningWithInformation(\ArrayType\ArrayOfDiningWith $diningWithInformation = null)
    {
        $this->DiningWithInformation = $diningWithInformation;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \StructType\AdditionaInfo|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \StructType\AdditionaInfo $additionalInfo
     * @return \StructType\Cabin
     */
    public function setAdditionalInfo(\StructType\AdditionaInfo $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get GuestsCabinInfo value
     * @return \ArrayType\ArrayOfGuestCabinInfo|null
     */
    public function getGuestsCabinInfo()
    {
        return $this->GuestsCabinInfo;
    }
    /**
     * Set GuestsCabinInfo value
     * @param \ArrayType\ArrayOfGuestCabinInfo $guestsCabinInfo
     * @return \StructType\Cabin
     */
    public function setGuestsCabinInfo(\ArrayType\ArrayOfGuestCabinInfo $guestsCabinInfo = null)
    {
        $this->GuestsCabinInfo = $guestsCabinInfo;
        return $this;
    }
    /**
     * Get RestaurantInfo value
     * @return \StructType\RestaurantInfo|null
     */
    public function getRestaurantInfo()
    {
        return $this->RestaurantInfo;
    }
    /**
     * Set RestaurantInfo value
     * @param \StructType\RestaurantInfo $restaurantInfo
     * @return \StructType\Cabin
     */
    public function setRestaurantInfo(\StructType\RestaurantInfo $restaurantInfo = null)
    {
        $this->RestaurantInfo = $restaurantInfo;
        return $this;
    }
    /**
     * Get DiningSatisfaction value
     * @return string|null
     */
    public function getDiningSatisfaction()
    {
        return $this->DiningSatisfaction;
    }
    /**
     * Set DiningSatisfaction value
     * @param string $diningSatisfaction
     * @return \StructType\Cabin
     */
    public function setDiningSatisfaction($diningSatisfaction = null)
    {
        // validation for constraint: string
        if (!is_null($diningSatisfaction) && !is_string($diningSatisfaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($diningSatisfaction)), __LINE__);
        }
        $this->DiningSatisfaction = $diningSatisfaction;
        return $this;
    }
    /**
     * Get ServiceLevel value
     * @return string|null
     */
    public function getServiceLevel()
    {
        return $this->ServiceLevel;
    }
    /**
     * Set ServiceLevel value
     * @param string $serviceLevel
     * @return \StructType\Cabin
     */
    public function setServiceLevel($serviceLevel = null)
    {
        // validation for constraint: string
        if (!is_null($serviceLevel) && !is_string($serviceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceLevel)), __LINE__);
        }
        $this->ServiceLevel = $serviceLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Cabin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
