<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionaInfo StructType
 * @subpackage Structs
 */
class AdditionaInfo extends AbstractStructBase
{
    /**
     * The WarningMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WarningMessage;
    /**
     * The InfoMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InfoMessage;
    /**
     * Constructor method for AdditionaInfo
     * @uses AdditionaInfo::setWarningMessage()
     * @uses AdditionaInfo::setInfoMessage()
     * @param string $warningMessage
     * @param string $infoMessage
     */
    public function __construct($warningMessage = null, $infoMessage = null)
    {
        $this
            ->setWarningMessage($warningMessage)
            ->setInfoMessage($infoMessage);
    }
    /**
     * Get WarningMessage value
     * @return string|null
     */
    public function getWarningMessage()
    {
        return $this->WarningMessage;
    }
    /**
     * Set WarningMessage value
     * @param string $warningMessage
     * @return \StructType\AdditionaInfo
     */
    public function setWarningMessage($warningMessage = null)
    {
        // validation for constraint: string
        if (!is_null($warningMessage) && !is_string($warningMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warningMessage)), __LINE__);
        }
        $this->WarningMessage = $warningMessage;
        return $this;
    }
    /**
     * Get InfoMessage value
     * @return string|null
     */
    public function getInfoMessage()
    {
        return $this->InfoMessage;
    }
    /**
     * Set InfoMessage value
     * @param string $infoMessage
     * @return \StructType\AdditionaInfo
     */
    public function setInfoMessage($infoMessage = null)
    {
        // validation for constraint: string
        if (!is_null($infoMessage) && !is_string($infoMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoMessage)), __LINE__);
        }
        $this->InfoMessage = $infoMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionaInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
