<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Sets the Agency SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Agency $agency
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAgency(\StructType\Agency $agency, $nameSpace = 'http://schemas.costacrociere.com/WebAffiliation', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Agency', $agency, $mustUnderstand, $actor);
    }
    /**
     * Sets the Partner SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Partner $partner
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPartner(\StructType\Partner $partner, $nameSpace = 'http://schemas.costacrociere.com/WebAffiliation', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Partner', $partner, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ListAvailableCruises
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all cruises: those cruises could be available or not, sellable or not. Possible parameter configuration are: (from), (from, to), (from, destination), (from, ship), (from, port), (from, to, destination),(from, to, ship),
     * (from, to, port) (from, destination, ship), (from, to, destination, ship),(from, destination, port), (from, to, destination, port), (from, destination, ship, port), (from, to, destination, ship, port), (from, ship, port), (from, to, ship, port).
     * Standard behaviours: - to omit a parameter set it as nil; - if the 'to' date is nil, the system returns all cruises that leave in date 'from' - if the 'to' date isn't nil, it must be within range 'from' + 30 days - the from date is always mandatory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAvailableCruises $parameters
     * @return \StructType\ListAvailableCruisesResponse|bool
     */
    public function ListAvailableCruises(\StructType\ListAvailableCruises $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAvailableCruises($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListAutomaticDiscounts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all automatic discount for a cruise
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAutomaticDiscounts $parameters
     * @return \StructType\ListAutomaticDiscountsResponse|bool
     */
    public function ListAutomaticDiscounts(\StructType\ListAutomaticDiscounts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAutomaticDiscounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListAllDestinations
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all available destinations for booking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAllDestinations $parameters
     * @return \StructType\ListAllDestinationsResponse|bool
     */
    public function ListAllDestinations(\StructType\ListAllDestinations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAllDestinations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListAllShips
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve available all ships for booking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAllShips $parameters
     * @return \StructType\ListAllShipsResponse|bool
     */
    public function ListAllShips(\StructType\ListAllShips $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAllShips($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListAllPorts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all available ports for booking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAllPorts $parameters
     * @return \StructType\ListAllPortsResponse|bool
     */
    public function ListAllPorts(\StructType\ListAllPorts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAllPorts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListShips
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all available ships for destination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListShips $parameters
     * @return \StructType\ListShipsResponse|bool
     */
    public function ListShips(\StructType\ListShips $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListShips($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListPorts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all ports available. Possible parameter configurations are: (destination), (ship), (destination, ship)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListPorts $parameters
     * @return \StructType\ListPortsResponse|bool
     */
    public function ListPorts(\StructType\ListPorts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListPorts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListFares
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all available fares for a cruise
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListFares $parameters
     * @return \StructType\ListFaresResponse|bool
     */
    public function ListFares(\StructType\ListFares $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListFares($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListAvailableCabins
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all available cabins for a category of a cruise
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAvailableCabins $parameters
     * @return \StructType\ListAvailableCabinsResponse|bool
     */
    public function ListAvailableCabins(\StructType\ListAvailableCabins $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAvailableCabins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListAvailableCabinsWithGroupBooking
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all available cabins for a category of a cruise
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAvailableCabinsWithGroupBooking $parameters
     * @return \StructType\ListAvailableCabinsWithGroupBookingResponse|bool
     */
    public function ListAvailableCabinsWithGroupBooking(\StructType\ListAvailableCabinsWithGroupBooking $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAvailableCabinsWithGroupBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListAvailableCategories
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all available categories for a category of a cruise
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAvailableCategories $parameters
     * @return \StructType\ListAvailableCategoriesResponse|bool
     */
    public function ListAvailableCategories(\StructType\ListAvailableCategories $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAvailableCategories($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListAvailableCategoriesWithGroupBooking
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all available categories for a category of a cruise
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAvailableCategoriesWithGroupBooking $parameters
     * @return \StructType\ListAvailableCategoriesWithGroupBookingResponse|bool
     */
    public function ListAvailableCategoriesWithGroupBooking(\StructType\ListAvailableCategoriesWithGroupBooking $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAvailableCategoriesWithGroupBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListAvailableSpecialServices
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Retrieve all available specialservices for a cruise
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAvailableSpecialServices $parameters
     * @return \StructType\ListAvailableSpecialServicesResponse|bool
     */
    public function ListAvailableSpecialServices(\StructType\ListAvailableSpecialServices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAvailableSpecialServices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListDocuments
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Get the documents needed for a booking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDocuments $parameters
     * @return \StructType\ListDocumentsResponse|bool
     */
    public function ListDocuments(\StructType\ListDocuments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListDocuments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListAllDestinationsResponse|\StructType\ListAllPortsResponse|\StructType\ListAllShipsResponse|\StructType\ListAutomaticDiscountsResponse|\StructType\ListAvailableCabinsResponse|\StructType\ListAvailableCabinsWithGroupBookingResponse|\StructType\ListAvailableCategoriesResponse|\StructType\ListAvailableCategoriesWithGroupBookingResponse|\StructType\ListAvailableCruisesResponse|\StructType\ListAvailableSpecialServicesResponse|\StructType\ListDocumentsResponse|\StructType\ListFaresResponse|\StructType\ListPortsResponse|\StructType\ListShipsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
