<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Sets the Agency SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Agency $agency
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAgency(\StructType\Agency $agency, $nameSpace = 'http://schemas.costacrociere.com/WebAffiliation', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Agency', $agency, $mustUnderstand, $actor);
    }
    /**
     * Sets the Partner SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Partner $partner
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPartner(\StructType\Partner $partner, $nameSpace = 'http://schemas.costacrociere.com/WebAffiliation', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Partner', $partner, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named IsCruiseInImmediateConfirmForFare
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Agency, Partner
     * - SOAPHeaderNamespaces: http://schemas.costacrociere.com/WebAffiliation, http://schemas.costacrociere.com/WebAffiliation
     * - SOAPHeaderTypes: \StructType\Agency, \StructType\Partner
     * - SOAPHeaders: required, required
     * - documentation: Return true if cruise is in ImmediateConfirm, false otherwise
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsCruiseInImmediateConfirmForFare $parameters
     * @return \StructType\IsCruiseInImmediateConfirmForFareResponse|bool
     */
    public function IsCruiseInImmediateConfirmForFare(\StructType\IsCruiseInImmediateConfirmForFare $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IsCruiseInImmediateConfirmForFare($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IsCruiseInImmediateConfirmForFareResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
