<?php

namespace EnumType;

/**
 * This class stands for ServicePriceCharges EnumType
 * @subpackage Enumerations
 */
class ServicePriceCharges
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Cabin'
     * @return string 'Cabin'
     */
    const VALUE_CABIN = 'Cabin';
    /**
     * Constant for value 'Pax'
     * @return string 'Pax'
     */
    const VALUE_PAX = 'Pax';
    /**
     * Constant for value 'DayPax'
     * @return string 'DayPax'
     */
    const VALUE_DAY_PAX = 'DayPax';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_CABIN
     * @uses self::VALUE_PAX
     * @uses self::VALUE_DAY_PAX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_CABIN,
            self::VALUE_PAX,
            self::VALUE_DAY_PAX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
