<?php

namespace EnumType;

/**
 * This class stands for Dining EnumType
 * @subpackage Enumerations
 */
class Dining
{
    /**
     * Constant for value 'Unspecified'
     * @return string 'Unspecified'
     */
    const VALUE_UNSPECIFIED = 'Unspecified';
    /**
     * Constant for value 'Main'
     * @return string 'Main'
     */
    const VALUE_MAIN = 'Main';
    /**
     * Constant for value 'Late'
     * @return string 'Late'
     */
    const VALUE_LATE = 'Late';
    /**
     * Constant for value 'OpenSeating'
     * @return string 'OpenSeating'
     */
    const VALUE_OPEN_SEATING = 'OpenSeating';
    /**
     * Constant for value 'FakeValue'
     * @return string 'FakeValue'
     */
    const VALUE_FAKE_VALUE = 'FakeValue';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNSPECIFIED
     * @uses self::VALUE_MAIN
     * @uses self::VALUE_LATE
     * @uses self::VALUE_OPEN_SEATING
     * @uses self::VALUE_FAKE_VALUE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNSPECIFIED,
            self::VALUE_MAIN,
            self::VALUE_LATE,
            self::VALUE_OPEN_SEATING,
            self::VALUE_FAKE_VALUE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
