<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransportationDetail ArrayType
 * @subpackage Arrays
 */
class ArrayOfTransportationDetail extends AbstractStructArrayBase
{
    /**
     * The TransportationDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransportationDetail[]
     */
    public $TransportationDetail;
    /**
     * Constructor method for ArrayOfTransportationDetail
     * @uses ArrayOfTransportationDetail::setTransportationDetail()
     * @param \StructType\TransportationDetail[] $transportationDetail
     */
    public function __construct(array $transportationDetail = array())
    {
        $this
            ->setTransportationDetail($transportationDetail);
    }
    /**
     * Get TransportationDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransportationDetail[]|null
     */
    public function getTransportationDetail()
    {
        return isset($this->TransportationDetail) ? $this->TransportationDetail : null;
    }
    /**
     * Set TransportationDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransportationDetail[] $transportationDetail
     * @return \ArrayType\ArrayOfTransportationDetail
     */
    public function setTransportationDetail(array $transportationDetail = array())
    {
        foreach ($transportationDetail as $arrayOfTransportationDetailTransportationDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransportationDetailTransportationDetailItem instanceof \StructType\TransportationDetail) {
                throw new \InvalidArgumentException(sprintf('The TransportationDetail property can only contain items of \StructType\TransportationDetail, "%s" given', is_object($arrayOfTransportationDetailTransportationDetailItem) ? get_class($arrayOfTransportationDetailTransportationDetailItem) : gettype($arrayOfTransportationDetailTransportationDetailItem)), __LINE__);
            }
        }
        if (is_null($transportationDetail) || (is_array($transportationDetail) && empty($transportationDetail))) {
            unset($this->TransportationDetail);
        } else {
            $this->TransportationDetail = $transportationDetail;
        }
        return $this;
    }
    /**
     * Add item to TransportationDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TransportationDetail $item
     * @return \ArrayType\ArrayOfTransportationDetail
     */
    public function addToTransportationDetail(\StructType\TransportationDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransportationDetail) {
            throw new \InvalidArgumentException(sprintf('The TransportationDetail property can only contain items of \StructType\TransportationDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransportationDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TransportationDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TransportationDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TransportationDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TransportationDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TransportationDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransportationDetail
     */
    public function getAttributeName()
    {
        return 'TransportationDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTransportationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
