<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShip ArrayType
 * @subpackage Arrays
 */
class ArrayOfShip extends AbstractStructArrayBase
{
    /**
     * The Ship
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Ship[]
     */
    public $Ship;
    /**
     * Constructor method for ArrayOfShip
     * @uses ArrayOfShip::setShip()
     * @param \StructType\Ship[] $ship
     */
    public function __construct(array $ship = array())
    {
        $this
            ->setShip($ship);
    }
    /**
     * Get Ship value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Ship[]|null
     */
    public function getShip()
    {
        return isset($this->Ship) ? $this->Ship : null;
    }
    /**
     * Set Ship value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Ship[] $ship
     * @return \ArrayType\ArrayOfShip
     */
    public function setShip(array $ship = array())
    {
        foreach ($ship as $arrayOfShipShipItem) {
            // validation for constraint: itemType
            if (!$arrayOfShipShipItem instanceof \StructType\Ship) {
                throw new \InvalidArgumentException(sprintf('The Ship property can only contain items of \StructType\Ship, "%s" given', is_object($arrayOfShipShipItem) ? get_class($arrayOfShipShipItem) : gettype($arrayOfShipShipItem)), __LINE__);
            }
        }
        if (is_null($ship) || (is_array($ship) && empty($ship))) {
            unset($this->Ship);
        } else {
            $this->Ship = $ship;
        }
        return $this;
    }
    /**
     * Add item to Ship value
     * @throws \InvalidArgumentException
     * @param \StructType\Ship $item
     * @return \ArrayType\ArrayOfShip
     */
    public function addToShip(\StructType\Ship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ship) {
            throw new \InvalidArgumentException(sprintf('The Ship property can only contain items of \StructType\Ship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ship[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Ship|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Ship|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Ship|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Ship|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Ship|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Ship
     */
    public function getAttributeName()
    {
        return 'Ship';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfShip
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
