<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomType ArrayType
 * @subpackage Arrays
 */
class ArrayOfRoomType extends AbstractStructArrayBase
{
    /**
     * The RoomType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoomType[]
     */
    public $RoomType;
    /**
     * Constructor method for ArrayOfRoomType
     * @uses ArrayOfRoomType::setRoomType()
     * @param \StructType\RoomType[] $roomType
     */
    public function __construct(array $roomType = array())
    {
        $this
            ->setRoomType($roomType);
    }
    /**
     * Get RoomType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoomType[]|null
     */
    public function getRoomType()
    {
        return isset($this->RoomType) ? $this->RoomType : null;
    }
    /**
     * Set RoomType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoomType[] $roomType
     * @return \ArrayType\ArrayOfRoomType
     */
    public function setRoomType(array $roomType = array())
    {
        foreach ($roomType as $arrayOfRoomTypeRoomTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomTypeRoomTypeItem instanceof \StructType\RoomType) {
                throw new \InvalidArgumentException(sprintf('The RoomType property can only contain items of \StructType\RoomType, "%s" given', is_object($arrayOfRoomTypeRoomTypeItem) ? get_class($arrayOfRoomTypeRoomTypeItem) : gettype($arrayOfRoomTypeRoomTypeItem)), __LINE__);
            }
        }
        if (is_null($roomType) || (is_array($roomType) && empty($roomType))) {
            unset($this->RoomType);
        } else {
            $this->RoomType = $roomType;
        }
        return $this;
    }
    /**
     * Add item to RoomType value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomType $item
     * @return \ArrayType\ArrayOfRoomType
     */
    public function addToRoomType(\StructType\RoomType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomType) {
            throw new \InvalidArgumentException(sprintf('The RoomType property can only contain items of \StructType\RoomType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoomType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoomType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoomType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoomType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoomType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoomType
     */
    public function getAttributeName()
    {
        return 'RoomType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
