<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomPrice ArrayType
 * @subpackage Arrays
 */
class ArrayOfRoomPrice extends AbstractStructArrayBase
{
    /**
     * The RoomPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoomPrice[]
     */
    public $RoomPrice;
    /**
     * Constructor method for ArrayOfRoomPrice
     * @uses ArrayOfRoomPrice::setRoomPrice()
     * @param \StructType\RoomPrice[] $roomPrice
     */
    public function __construct(array $roomPrice = array())
    {
        $this
            ->setRoomPrice($roomPrice);
    }
    /**
     * Get RoomPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoomPrice[]|null
     */
    public function getRoomPrice()
    {
        return isset($this->RoomPrice) ? $this->RoomPrice : null;
    }
    /**
     * Set RoomPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoomPrice[] $roomPrice
     * @return \ArrayType\ArrayOfRoomPrice
     */
    public function setRoomPrice(array $roomPrice = array())
    {
        foreach ($roomPrice as $arrayOfRoomPriceRoomPriceItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomPriceRoomPriceItem instanceof \StructType\RoomPrice) {
                throw new \InvalidArgumentException(sprintf('The RoomPrice property can only contain items of \StructType\RoomPrice, "%s" given', is_object($arrayOfRoomPriceRoomPriceItem) ? get_class($arrayOfRoomPriceRoomPriceItem) : gettype($arrayOfRoomPriceRoomPriceItem)), __LINE__);
            }
        }
        if (is_null($roomPrice) || (is_array($roomPrice) && empty($roomPrice))) {
            unset($this->RoomPrice);
        } else {
            $this->RoomPrice = $roomPrice;
        }
        return $this;
    }
    /**
     * Add item to RoomPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomPrice $item
     * @return \ArrayType\ArrayOfRoomPrice
     */
    public function addToRoomPrice(\StructType\RoomPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomPrice) {
            throw new \InvalidArgumentException(sprintf('The RoomPrice property can only contain items of \StructType\RoomPrice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomPrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoomPrice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoomPrice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoomPrice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoomPrice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoomPrice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoomPrice
     */
    public function getAttributeName()
    {
        return 'RoomPrice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRoomPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
